/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.core;

import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CapabilityHelpers {
    public static final List<Capability<? extends IChemicalHandler<?, ?>>> CHEMICAL_CAPABILITIES = List.of(Capabilities.GAS_HANDLER, Capabilities.INFUSION_HANDLER, Capabilities.PIGMENT_HANDLER, Capabilities.SLURRY_HANDLER);

    public static <T extends IChemicalHandler<?, ?>> LazyOptional<T> getFirstOf(PartPos pos, List<Capability<? extends T>> capabilities) {
        LazyOptional lazyOptional = LazyOptional.empty();
        for (Capability<T> capability : capabilities) {
            LazyOptional lazyOptionalCurrent = BlockEntityHelpers.getCapability((DimPos)pos.getPos(), (Direction)pos.getSide(), capability).cast();
            if (!lazyOptional.isPresent()) {
                lazyOptional = lazyOptionalCurrent;
                continue;
            }
            if (!lazyOptionalCurrent.isPresent() || !CapabilityHelpers.hasChemical((IChemicalHandler)lazyOptionalCurrent.resolve().get())) continue;
            lazyOptional = lazyOptionalCurrent;
            break;
        }
        return lazyOptional;
    }

    public static boolean hasChemical(IChemicalHandler<?, ?> handler) {
        int tanks = handler.getTanks();
        for (int i = 0; i < tanks; ++i) {
            if (handler.getChemicalInTank(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static <T extends IChemicalHandler<?, ?>> LazyOptional<T> getFirstOf(ItemStack itemStack, @Nullable Chemical<?> preferChemical, List<Capability<? extends T>> capabilities) {
        LazyOptional lazyOptionalFirst = LazyOptional.empty();
        for (Capability<T> capability : capabilities) {
            LazyOptional lazyOptionalCurrent = itemStack.getCapability(capability).cast();
            if (!lazyOptionalCurrent.isPresent()) continue;
            IChemicalHandler handler = (IChemicalHandler)lazyOptionalCurrent.resolve().get();
            boolean matchPreferChemical = false;
            if (preferChemical != null && !(matchPreferChemical = preferChemical instanceof Gas && handler instanceof IGasHandler || preferChemical instanceof InfuseType && handler instanceof IInfusionHandler || preferChemical instanceof Pigment && handler instanceof IPigmentHandler || preferChemical instanceof Slurry && handler instanceof ISlurryHandler)) continue;
            if (handler.getTanks() > 0 && (matchPreferChemical || !handler.getChemicalInTank(0).isEmpty())) {
                return lazyOptionalCurrent;
            }
            if (lazyOptionalFirst.isPresent()) continue;
            lazyOptionalFirst = lazyOptionalCurrent;
        }
        return lazyOptionalFirst;
    }

    public static LazyOptional<IChemicalHandler<?, ?>> getChemicalHandler(ItemStack itemStack, @Nullable Chemical<?> preferChemical) {
        return CapabilityHelpers.getFirstOf(itemStack, preferChemical, CHEMICAL_CAPABILITIES);
    }

    public static LazyOptional<IChemicalHandler<?, ?>> getChemicalHandler(ItemStack itemStack) {
        return CapabilityHelpers.getChemicalHandler(itemStack, null);
    }
}

