/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeStringLPElementRenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integratedmekanism.IntegratedMekanism;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.logicprogrammer.MekanismLogicProgrammerElementTypes;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElementMasterSubGui;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElementRecipeSubGui;
import org.cyclops.integratedmekanism.network.packet.LogicProgrammerValueTypeRecipeChemicalSlotPropertiesChangedPacket;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class ValueTypeRecipeChemicalLPElement
implements IValueTypeLogicProgrammerElement<ISubGuiBox, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> {
    public static final int SLOT_OFFSET = 4;
    public static final int SLOTS_PER_TYPE = 2;
    private static final IConfigRenderPattern CONFIG_RENDER_PATTERN = new IConfigRenderPattern.Base(154, 89, new Pair[]{Pair.of((Object)20, (Object)0), Pair.of((Object)52, (Object)0), Pair.of((Object)20, (Object)18), Pair.of((Object)20, (Object)36), Pair.of((Object)20, (Object)54), Pair.of((Object)20, (Object)72), Pair.of((Object)98, (Object)0), Pair.of((Object)130, (Object)0), Pair.of((Object)98, (Object)18), Pair.of((Object)98, (Object)36), Pair.of((Object)98, (Object)54), Pair.of((Object)98, (Object)72)}, null);
    @OnlyIn(value=Dist.CLIENT)
    public ValueTypeRecipeChemicalLPElementMasterSubGui lastGui;
    private List<ItemMatchProperties> inputStacks;
    private List<Pair<ItemStack, String>> inputFluids;
    private List<Pair<ItemStack, String>> inputChemicals;
    private List<ItemStack> outputStacks;
    private List<Pair<ItemStack, String>> outputFluids;
    private List<Pair<ItemStack, String>> outputChemicals;

    public ValueTypeRecipeChemicalLPElement() {
        this.activate();
    }

    public List<ItemMatchProperties> getInputStacks() {
        return this.inputStacks;
    }

    public List<Pair<ItemStack, String>> getInputFluids() {
        return this.inputFluids;
    }

    public List<Pair<ItemStack, String>> getInputChemicals() {
        return this.inputChemicals;
    }

    public List<ItemStack> getOutputStacks() {
        return this.outputStacks;
    }

    public List<Pair<ItemStack, String>> getOutputFluids() {
        return this.outputFluids;
    }

    public List<Pair<ItemStack, String>> getOutputChemicals() {
        return this.outputChemicals;
    }

    @Nullable
    public <G2 extends Screen, C2 extends AbstractContainerMenu> IGuiInputElementValueType<?, G2, C2> createInnerGuiElement() {
        return null;
    }

    @Nullable
    public IGuiInputElementValueType<?, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> getInnerGuiElement() {
        return null;
    }

    public void loadTooltip(List<Component> lines) {
        this.getValueType().loadTooltip(lines, true, null);
    }

    public ILogicProgrammerElementType getType() {
        return MekanismLogicProgrammerElementTypes.VALUETYPE_RECIPE_CHEMICAL;
    }

    public String getMatchString() {
        return this.getName().getString().toLowerCase();
    }

    public boolean matchesInput(IValueType<?> valueType) {
        return false;
    }

    public boolean matchesOutput(IValueType<?> valueType) {
        return ValueHelpers.correspondsTo(valueType, valueType);
    }

    public Component getName() {
        return Component.m_237115_((String)"gui.integratedmekanism.logicprogrammer.element.recipechemical.name");
    }

    public IConfigRenderPattern getRenderPattern() {
        return CONFIG_RENDER_PATTERN;
    }

    public void onInputSlotUpdated(Player player, int slotId, ItemStack itemStack) {
        int amount;
        String amountString;
        ItemStack itemStackOld;
        if (this.inputStacks == null) {
            return;
        }
        boolean refreshAmountBoxes = false;
        if (slotId >= 0 && slotId < 2 && (itemStackOld = this.inputStacks.get(slotId).getItemStack()).m_41720_() != itemStack.m_41720_()) {
            this.inputStacks.set(slotId, new ItemMatchProperties(itemStack.m_41777_()));
            if (MinecraftHelpers.isClientSideThread()) {
                this.refreshPropertiesGui(slotId);
            }
        }
        if (slotId >= 2 && slotId < 4) {
            int index = slotId - 2;
            amountString = (String)this.inputFluids.get(index).getRight();
            if (amountString.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack((ItemStack)((ItemStack)this.inputFluids.get(index).getLeft())));
                amountString = Integer.toString(amount);
            }
            this.inputFluids.set(index, (Pair<ItemStack, String>)Pair.of((Object)itemStack.m_41777_(), (Object)amountString));
            refreshAmountBoxes = true;
        }
        if (slotId >= 4 && slotId < 6) {
            int index = slotId - 4;
            amountString = (String)this.inputChemicals.get(index).getRight();
            if (amountString.equalsIgnoreCase("0")) {
                amount = ValueTypeRecipeChemicalLPElement.getChemicalAmount((ItemStack)this.inputChemicals.get(index).getLeft());
                amountString = Integer.toString(amount);
            }
            this.inputChemicals.set(index, (Pair<ItemStack, String>)Pair.of((Object)itemStack.m_41777_(), (Object)amountString));
            refreshAmountBoxes = true;
        }
        if (slotId >= 6 && slotId < 8) {
            this.outputStacks.set(slotId - 6, itemStack.m_41777_());
        }
        if (slotId >= 8 && slotId < 10) {
            int index = slotId - 8;
            amountString = (String)this.outputFluids.get(index).getRight();
            if (amountString.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack((ItemStack)((ItemStack)this.outputFluids.get(index).getLeft())));
                amountString = Integer.toString(amount);
            }
            this.outputFluids.set(index, (Pair<ItemStack, String>)Pair.of((Object)itemStack.m_41777_(), (Object)amountString));
            refreshAmountBoxes = true;
        }
        if (slotId >= 10 && slotId < 12) {
            int index = slotId - 10;
            amountString = (String)this.outputChemicals.get(index).getRight();
            if (amountString.equalsIgnoreCase("0")) {
                amount = ValueTypeRecipeChemicalLPElement.getChemicalAmount((ItemStack)this.outputChemicals.get(index).getLeft());
                amountString = Integer.toString(amount);
            }
            this.outputChemicals.set(index, (Pair<ItemStack, String>)Pair.of((Object)itemStack.m_41777_(), (Object)amountString));
            refreshAmountBoxes = true;
        }
        if (refreshAmountBoxes && MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
            this.refreshAmountBoxes();
        }
    }

    protected static ChemicalStack<?> getChemical(ItemStack itemStack) {
        return (ChemicalStack)CapabilityHelpers.getChemicalHandler(itemStack).map(handler -> {
            int tanks = handler.getTanks();
            for (int i = 0; i < tanks; ++i) {
                if (handler.getChemicalInTank(i).isEmpty()) continue;
                return handler.getChemicalInTank(i);
            }
            return GasStack.EMPTY;
        }).orElse(GasStack.EMPTY);
    }

    protected static int getChemicalAmount(ItemStack itemStack) {
        return (int)ValueTypeRecipeChemicalLPElement.getChemical(itemStack).getAmount();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshPropertiesGui(int slot) {
        if (this.lastGui != null && this.lastGui.isPropertySubGuiActive(slot)) {
            this.lastGui.propertiesSubGuis.get(slot).loadStateToGui();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshAmountBoxes() {
        if (this.lastGui != null && !this.lastGui.subGuiRecipe.getInputFluidAmounts().isEmpty()) {
            for (int i = 0; i < 2; ++i) {
                this.lastGui.subGuiRecipe.getInputFluidAmounts().get(i).m_94144_((String)this.inputFluids.get(i).getRight());
                this.lastGui.subGuiRecipe.getInputChemicalAmounts().get(i).m_94144_((String)this.inputChemicals.get(i).getRight());
                this.lastGui.subGuiRecipe.getOutputFluidAmounts().get(i).m_94144_((String)this.outputFluids.get(i).getRight());
                this.lastGui.subGuiRecipe.getOutputChemicalAmounts().get(i).m_94144_((String)this.outputChemicals.get(i).getRight());
            }
        }
    }

    public void sendSlotPropertiesToServer(int slotId, ItemMatchProperties props) {
        IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalSlotPropertiesChangedPacket(slotId, props.isNbt(), props.getItemTag() == null ? "" : props.getItemTag(), props.getTagQuantity(), props.isReusable()));
    }

    public boolean isValidForRecipeGrid(List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ChemicalStack<?>> chemicalInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs, List<ChemicalStack<?>> chemicalOutputs) {
        return itemInputs.size() <= 2 && fluidInputs.size() <= 2 && chemicalInputs.size() <= 2 && itemOutputs.size() <= 2 && fluidOutputs.size() <= 2 && chemicalOutputs.size() <= 2;
    }

    protected void putItemPropertiesInContainer(ContainerLogicProgrammerBase container, int slot, ItemMatchProperties props) {
        this.putStackInContainer(container, slot, props.getItemStack());
        this.getInputStacks().set(slot, props);
    }

    protected void putStackInContainer(ContainerLogicProgrammerBase container, int slot, ItemStack itemStack) {
        container.m_182406_(container.m_38927_().size() - 48 + slot, 0, itemStack);
    }

    public void setRecipeGrid(ContainerLogicProgrammerBase container, List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ChemicalStack<?>> chemicalInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs, List<ChemicalStack<?>> chemicalOutputs) {
        ChemicalStack<?> output;
        int i;
        String amount;
        ItemStack stack;
        ChemicalStack<?> input;
        int i2;
        int slot = 0;
        for (ItemMatchProperties itemInput : itemInputs) {
            this.putItemPropertiesInContainer(container, slot, itemInput);
            ++slot;
        }
        while (slot < 2) {
            this.putItemPropertiesInContainer(container, slot, new ItemMatchProperties(ItemStack.f_41583_));
            ++slot;
        }
        for (i2 = 0; i2 < 2; ++i2) {
            input = FluidStack.EMPTY;
            if (fluidInputs.size() > i2) {
                input = fluidInputs.get(i2);
            }
            stack = input.isEmpty() ? ItemStack.f_41583_ : ValueTypeRecipeLPElement.getFluidBucket((FluidStack)input);
            amount = String.valueOf(FluidHelpers.getAmount((FluidStack)input));
            this.putStackInContainer(container, slot, stack);
            this.inputFluids.set(i2, (Pair<ItemStack, String>)Pair.of((Object)stack, (Object)amount));
            ++slot;
        }
        for (i2 = 0; i2 < 2; ++i2) {
            input = GasStack.EMPTY;
            if (i2 < chemicalInputs.size()) {
                input = chemicalInputs.get(i2);
            }
            stack = input.isEmpty() ? ItemStack.f_41583_ : ValueObjectTypeChemicalStack.valueToItemStack(input);
            amount = String.valueOf(input.getAmount());
            this.putStackInContainer(container, slot, stack);
            this.inputChemicals.set(i2, (Pair<ItemStack, String>)Pair.of((Object)stack, (Object)amount));
            ++slot;
        }
        for (ItemStack itemOutput : itemOutputs) {
            this.putStackInContainer(container, slot, itemOutput);
            ++slot;
        }
        while (slot < 8) {
            this.putStackInContainer(container, slot, ItemStack.f_41583_);
            ++slot;
        }
        for (i = 0; i < 2; ++i) {
            output = FluidStack.EMPTY;
            if (i < fluidOutputs.size()) {
                output = fluidOutputs.get(i);
            }
            stack = output.isEmpty() ? ItemStack.f_41583_ : ValueTypeRecipeLPElement.getFluidBucket((FluidStack)output);
            amount = String.valueOf(FluidHelpers.getAmount((FluidStack)output));
            this.putStackInContainer(container, slot, stack);
            this.outputFluids.set(i, (Pair<ItemStack, String>)Pair.of((Object)stack, (Object)amount));
            ++slot;
        }
        for (i = 0; i < 2; ++i) {
            output = GasStack.EMPTY;
            if (i < chemicalOutputs.size()) {
                output = chemicalOutputs.get(i);
            }
            stack = output.isEmpty() ? ItemStack.f_41583_ : ValueObjectTypeChemicalStack.valueToItemStack(output);
            amount = String.valueOf(output.getAmount());
            this.putStackInContainer(container, slot, stack);
            this.outputChemicals.set(i, (Pair<ItemStack, String>)Pair.of((Object)stack, (Object)amount));
            ++slot;
        }
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshAmountBoxes();
        }
    }

    protected boolean isInputValid() {
        return this.inputStacks.stream().anyMatch(ItemMatchProperties::isValid) || this.inputFluids.stream().anyMatch(pair -> !((ItemStack)pair.getLeft()).m_41619_() || !((String)pair.getRight()).equalsIgnoreCase("0")) || this.inputChemicals.stream().anyMatch(pair -> !((ItemStack)pair.getLeft()).m_41619_() || !((String)pair.getRight()).equalsIgnoreCase("0"));
    }

    protected boolean isOutputValid() {
        return this.outputStacks.stream().anyMatch(ItemStack::m_41619_) || this.outputFluids.stream().anyMatch(pair -> !((ItemStack)pair.getLeft()).m_41619_() || !((String)pair.getRight()).equalsIgnoreCase("0")) || this.outputChemicals.stream().anyMatch(pair -> !((ItemStack)pair.getLeft()).m_41619_() || !((String)pair.getRight()).equalsIgnoreCase("0"));
    }

    public boolean isFor(IVariableFacade variableFacade) {
        IValueTypeVariableFacade valueTypeFacade;
        if (variableFacade instanceof IValueTypeVariableFacade && (valueTypeFacade = (IValueTypeVariableFacade)variableFacade).isValid() && this.getValueType() == valueTypeFacade.getValueType()) {
            ValueObjectTypeRecipe.ValueRecipe recipe = (ValueObjectTypeRecipe.ValueRecipe)((IValueTypeVariableFacade)variableFacade).getValue();
            return recipe.getRawValue().map(r -> r.getInputComponents().contains(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK) || r.getOutput().getComponents().contains(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK)).orElse(false);
        }
        return false;
    }

    public boolean canWriteElementPre() {
        return this.isInputValid() == this.isOutputValid();
    }

    public ItemStack writeElement(Player player, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(!player.m_9236_().m_5776_(), itemStack, (IVariableFacadeHandler)ValueTypes.REGISTRY, (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new ValueTypeLPElementBase.ValueTypeVariableFacadeFactory(this.getValueType(), this.getValue()), player.m_9236_(), player, RegistryEntries.BLOCK_LOGIC_PROGRAMMER.m_49966_());
    }

    public void loadElement(IVariableFacade variableFacade) {
        if (variableFacade instanceof IValueTypeVariableFacade) {
            IValueTypeVariableFacade valueTypeVariableFacade = (IValueTypeVariableFacade)variableFacade;
            this.setValue(valueTypeVariableFacade.getValue());
        }
    }

    public boolean canCurrentlyReadFromOtherItem() {
        return true;
    }

    public void activate() {
        int i;
        this.inputStacks = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            this.inputStacks.add(new ItemMatchProperties(ItemStack.f_41583_));
        }
        this.inputFluids = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            this.inputFluids.add((Pair<ItemStack, String>)Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
        }
        this.inputChemicals = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            this.inputChemicals.add((Pair<ItemStack, String>)Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
        }
        this.outputStacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        this.outputFluids = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            this.outputFluids.add(i, (Pair<ItemStack, String>)Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
        }
        this.outputChemicals = Lists.newArrayList();
        for (i = 0; i < 2; ++i) {
            this.outputChemicals.add((Pair<ItemStack, String>)Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
        }
    }

    public void deactivate() {
    }

    public Component validate() {
        for (Pair<ItemStack, String> input : this.inputFluids) {
            if (!((ItemStack)input.getLeft()).m_41619_() && Helpers.getFluidStack((ItemStack)((ItemStack)input.getLeft())).isEmpty()) {
                return Component.m_237115_((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
            }
            try {
                Integer.parseInt((String)input.getRight());
            }
            catch (NumberFormatException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{input.getRight()});
            }
        }
        for (Pair<ItemStack, String> input : this.outputFluids) {
            if (!((ItemStack)input.getLeft()).m_41619_() && Helpers.getFluidStack((ItemStack)((ItemStack)input.getLeft())).isEmpty()) {
                return Component.m_237115_((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
            }
            try {
                Integer.parseInt((String)input.getRight());
            }
            catch (NumberFormatException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{input.getRight()});
            }
        }
        for (Pair<ItemStack, String> input : this.inputChemicals) {
            if (!((ItemStack)input.getLeft()).m_41619_() && !CapabilityHelpers.getChemicalHandler((ItemStack)input.getLeft()).isPresent()) {
                return Component.m_237115_((String)"valuetype.integratedmekanism.error.chemical.no_chemical");
            }
            try {
                Integer.parseInt((String)input.getRight());
            }
            catch (NumberFormatException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{input.getRight()});
            }
        }
        for (Pair<ItemStack, String> input : this.outputChemicals) {
            if (!((ItemStack)input.getLeft()).m_41619_() && !CapabilityHelpers.getChemicalHandler((ItemStack)input.getLeft()).isPresent()) {
                return Component.m_237115_((String)"valuetype.integratedmekanism.error.chemical.no_chemical");
            }
            try {
                Integer.parseInt((String)input.getRight());
            }
            catch (NumberFormatException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{input.getRight()});
            }
        }
        for (ItemMatchProperties inputStack : this.inputStacks) {
            if (inputStack.getItemTag() == null) continue;
            try {
                new ResourceLocation(inputStack.getItemTag());
            }
            catch (ResourceLocationException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{inputStack.getItemTag()});
            }
        }
        return null;
    }

    public int getColor() {
        return ValueTypes.OBJECT_RECIPE.getDisplayColor();
    }

    public String getSymbol() {
        return L10NHelpers.localize((String)"gui.integratedmekanism.logicprogrammer.element.recipechemical.name", (Object[])new Object[0]);
    }

    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, Player player) {
        return ValueTypeRecipeLPElement.slotClickCommon((int)slotId, (Slot)slot, (int)mouseButton, (ClickType)clickType, (Player)player, this.getInputStacks(), (int)2, i -> {
            if (MinecraftHelpers.isClientSideThread()) {
                this.lastGui.setPropertySubGui((int)i);
            }
        }, i -> {
            if (MinecraftHelpers.isClientSideThread()) {
                this.refreshPropertiesGui((int)i);
            }
        });
    }

    public Slot createSlot(Container temporaryInputSlots, final int slotId, int x, int y) {
        SlotExtended slot = new SlotExtended(temporaryInputSlots, slotId, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                return ValueTypeRecipeChemicalLPElement.this.isItemValidForSlot(slotId, itemStack);
            }

            public ItemStack m_7993_() {
                if (MinecraftHelpers.isClientSideThread() && slotId < 2) {
                    return ValueTypeRecipeLPElement.getRotatingItemFromTag((ItemMatchProperties)ValueTypeRecipeChemicalLPElement.this.getInputStacks().get(slotId)).orElseGet(() -> super.m_7993_());
                }
                return super.m_7993_();
            }
        };
        slot.setPhantom(true);
        return slot;
    }

    public int getItemStackSizeLimit() {
        return 64;
    }

    protected static <T> List<T> spliceTrailingEmpty(List<T> list, Predicate<T> isEmpty) {
        int lastNonEmpty = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (isEmpty.test(list.get(i))) continue;
            lastNonEmpty = i + 1;
        }
        return list.subList(0, lastNonEmpty);
    }

    protected List<FluidStack> convertFluidStacks(List<Pair<ItemStack, String>> fluidPairs) {
        return IntStream.range(0, 2).mapToObj(i -> {
            if (i >= fluidPairs.size()) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = Helpers.getFluidStack((ItemStack)((ItemStack)((Pair)fluidPairs.get(i)).getLeft()));
            if (!fluidStack.isEmpty()) {
                fluidStack.setAmount(Integer.parseInt((String)((Pair)fluidPairs.get(i)).getRight()));
            }
            return fluidStack;
        }).filter(i -> !i.isEmpty()).toList();
    }

    protected List<ChemicalStack<?>> convertChemicalStacks(List<Pair<ItemStack, String>> chemicalPairs) {
        return IntStream.range(0, 2).mapToObj(i -> {
            if (i >= chemicalPairs.size()) {
                return GasStack.EMPTY;
            }
            ChemicalStack<?> chemicalStack = ValueTypeRecipeChemicalLPElement.getChemical((ItemStack)((Pair)chemicalPairs.get(i)).getLeft());
            if (!chemicalStack.isEmpty()) {
                chemicalStack.setAmount((long)Integer.parseInt((String)((Pair)chemicalPairs.get(i)).getRight()));
            }
            return chemicalStack;
        }).filter(i -> !i.isEmpty()).toList();
    }

    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getInputs(List<ItemMatchProperties> itemStacks, List<Pair<ItemStack, String>> fluidPairsIn, List<Pair<ItemStack, String>> chemicalPairsIn) {
        itemStacks = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(itemStacks, props -> !props.isValid());
        List<Pair<ItemStack, String>> fluidPairs = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(fluidPairsIn, pair -> ((ItemStack)pair.getLeft()).m_41619_());
        List<Pair<ItemStack, String>> chemicalPairs = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(chemicalPairsIn, pair -> ((ItemStack)pair.getLeft()).m_41619_());
        List<FluidStack> fluidStacks = this.convertFluidStacks(fluidPairs);
        List<ChemicalStack<?>> chemicalStacks = this.convertChemicalStacks(chemicalPairs);
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(ItemMatchProperties::createPrototypedIngredient).collect(Collectors.toList());
        List<PrototypedIngredientAlternativesList> fluids = fluidStacks.stream().map(fluidStack -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, fluidStack, (Object)3)))).toList();
        List<PrototypedIngredientAlternativesList> chemicals = chemicalStacks.stream().map(chemicalStack -> new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, chemicalStack, (Object)1)))).toList();
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        if (!fluids.isEmpty()) {
            inputs.put(IngredientComponent.FLUIDSTACK, fluids);
        }
        if (!chemicals.isEmpty()) {
            inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, chemicals);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<?>> getOutputs(List<ItemStack> itemStacksIn, List<Pair<ItemStack, String>> fluidPairsIn, List<Pair<ItemStack, String>> chemicalPairsIn) {
        List<ItemStack> itemStacks = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(itemStacksIn, ItemStack::m_41619_);
        List<Pair<ItemStack, String>> fluidPairs = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(fluidPairsIn, pair -> ((ItemStack)pair.getLeft()).m_41619_());
        List<Pair<ItemStack, String>> chemicalPairs = ValueTypeRecipeChemicalLPElement.spliceTrailingEmpty(chemicalPairsIn, pair -> ((ItemStack)pair.getLeft()).m_41619_());
        List<FluidStack> fluidStacks = this.convertFluidStacks(fluidPairs);
        List<ChemicalStack<?>> chemicalStacks = this.convertChemicalStacks(chemicalPairs);
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!itemStacks.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, itemStacks);
        }
        if (!fluidStacks.isEmpty()) {
            outputs.put(IngredientComponent.FLUIDSTACK, fluidStacks);
        }
        if (!chemicalStacks.isEmpty()) {
            outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, chemicalStacks);
        }
        return outputs;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFocused(ISubGuiBox subGui) {
        if (subGui instanceof ValueTypeStringLPElementRenderPattern) {
            return ((ValueTypeStringLPElementRenderPattern)subGui).getTextField().m_93696_();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFocused(ISubGuiBox subGui, boolean focused) {
        if (subGui instanceof ValueTypeStringLPElementRenderPattern) {
            ((ValueTypeStringLPElementRenderPattern)subGui).getTextField().m_93692_(focused);
        }
    }

    public IValueType<?> getValueType() {
        return ValueTypes.OBJECT_RECIPE;
    }

    public IValue getValue() {
        if (!this.isInputValid() && !this.isOutputValid()) {
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }
        return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition(this.getInputs(this.inputStacks, this.inputFluids, this.inputChemicals), ValueTypeRecipeLPElement.getInputsReusable(this.inputStacks), (IMixedIngredients)new MixedIngredients(this.getOutputs(this.outputStacks, this.outputFluids, this.outputChemicals))));
    }

    public void setValue(IValue value) {
        ValueObjectTypeRecipe.ValueRecipe valueRecipe = (ValueObjectTypeRecipe.ValueRecipe)value;
        valueRecipe.getRawValue().ifPresent(recipe -> {
            this.loadInputItems((IRecipeDefinition)recipe);
            this.loadInputFluids((IRecipeDefinition)recipe);
            this.loadInputChemicals((IRecipeDefinition)recipe);
            this.loadOutputItems((IRecipeDefinition)recipe);
            this.loadOutputFluids((IRecipeDefinition)recipe);
            this.loadOutputChemicals((IRecipeDefinition)recipe);
        });
    }

    private void loadInputItems(IRecipeDefinition recipe) {
        List listAlternatives = recipe.getInputs(IngredientComponent.ITEMSTACK);
        for (int i = 0; i < listAlternatives.size(); ++i) {
            IPrototypedIngredientAlternatives prototypes = (IPrototypedIngredientAlternatives)listAlternatives.get(i);
            boolean reusable = recipe.isInputReusable(IngredientComponent.ITEMSTACK, i);
            ItemMatchProperties itemMatchProperties = ItemMatchProperties.fromPrototypedIngredient((IPrototypedIngredientAlternatives)prototypes, (boolean)reusable);
            this.inputStacks.set(i, itemMatchProperties);
        }
    }

    protected static <T> List<T> ensureLength(List<T> list, int minLength, T filler) {
        if (list.size() > minLength) {
            return list.subList(0, minLength);
        }
        if (list.size() < minLength) {
            return Stream.concat(list.stream(), IntStream.range(0, minLength - list.size()).mapToObj(i -> filler)).collect(Collectors.toList());
        }
        return list;
    }

    private <T, M> List<T> loadFirstInputs(IRecipeDefinition recipe, IngredientComponent<T, M> ingredientComponent) {
        List listAlternatives = recipe.getInputs(ingredientComponent);
        return ValueTypeRecipeChemicalLPElement.ensureLength(listAlternatives.stream().map(prototypes -> {
            if (!prototypes.getAlternatives().isEmpty()) {
                return ((IPrototypedIngredient)prototypes.getAlternatives().stream().findFirst().get()).getPrototype();
            }
            return ingredientComponent.getMatcher().getEmptyInstance();
        }).toList(), 2, ingredientComponent.getMatcher().getEmptyInstance());
    }

    private void loadInputFluids(IRecipeDefinition recipe) {
        this.inputFluids = this.loadFirstInputs(recipe, IngredientComponent.FLUIDSTACK).stream().map(fluidStack -> Pair.of((Object)(fluidStack.isEmpty() ? ItemStack.f_41583_ : ValueTypeRecipeLPElement.getFluidBucket((FluidStack)fluidStack)), (Object)Integer.toString(fluidStack.getAmount()))).collect(Collectors.toList());
    }

    private void loadInputChemicals(IRecipeDefinition recipe) {
        this.inputChemicals = this.loadFirstInputs(recipe, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).stream().map(chemicalStack -> Pair.of((Object)(chemicalStack.isEmpty() ? ItemStack.f_41583_ : ValueObjectTypeChemicalStack.valueToItemStack(chemicalStack)), (Object)Integer.toString((int)chemicalStack.getAmount()))).collect(Collectors.toList());
    }

    private void loadOutputItems(IRecipeDefinition recipe) {
        List instances = recipe.getOutput().getInstances(IngredientComponent.ITEMSTACK);
        if (instances.size() > 0) {
            this.outputStacks.set(0, (ItemStack)instances.get(0));
        }
        if (instances.size() > 1) {
            this.outputStacks.set(1, (ItemStack)instances.get(1));
        }
    }

    private void loadOutputFluids(IRecipeDefinition recipe) {
        this.outputFluids = ValueTypeRecipeChemicalLPElement.ensureLength(recipe.getOutput().getInstances(IngredientComponent.FLUIDSTACK).stream().map(fluidStack -> Pair.of((Object)ValueTypeRecipeLPElement.getFluidBucket((FluidStack)fluidStack), (Object)Integer.toString(fluidStack.getAmount()))).toList(), 2, Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
    }

    private void loadOutputChemicals(IRecipeDefinition recipe) {
        this.outputChemicals = ValueTypeRecipeChemicalLPElement.ensureLength(recipe.getOutput().getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).stream().map(chemicalStack -> Pair.of((Object)ValueObjectTypeChemicalStack.valueToItemStack(chemicalStack), (Object)Integer.toString((int)chemicalStack.getAmount()))).toList(), 2, Pair.of((Object)ItemStack.f_41583_, (Object)"0"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        ValueTypeRecipeChemicalLPElementRecipeSubGui gui = ((ValueTypeRecipeChemicalLPElementMasterSubGui)subGui).getSubGuiRecipe();
        this.setValueInContainer((ContainerLogicProgrammerBase)gui.getContainer());
        if (gui.getInputFluidAmounts() != null) {
            int i;
            for (i = 0; i < 2; ++i) {
                gui.getInputFluidAmounts().get(i).m_94144_((String)this.inputFluids.get(i).getRight());
            }
            for (i = 0; i < 2; ++i) {
                gui.getInputChemicalAmounts().get(i).m_94144_((String)this.inputChemicals.get(i).getRight());
            }
            for (i = 0; i < 2; ++i) {
                gui.getOutputFluidAmounts().get(i).m_94144_((String)this.outputFluids.get(i).getRight());
            }
            for (i = 0; i < 2; ++i) {
                gui.getOutputChemicalAmounts().get(i).m_94144_((String)this.outputChemicals.get(i).getRight());
            }
        }
    }

    public void setValueInContainer(ContainerLogicProgrammerBase container) {
        int i;
        SimpleInventory slots = container.getTemporaryInputSlots();
        int slot = 0;
        for (i = 0; i < this.inputStacks.size(); ++i) {
            slots.m_6836_(slot++, this.inputStacks.get(i).getItemStack());
        }
        for (i = 0; i < this.inputFluids.size(); ++i) {
            slots.m_6836_(slot++, (ItemStack)this.inputFluids.get(i).getLeft());
        }
        for (i = 0; i < this.inputChemicals.size(); ++i) {
            slots.m_6836_(slot++, (ItemStack)this.inputChemicals.get(i).getLeft());
        }
        for (i = 0; i < this.outputStacks.size(); ++i) {
            slots.m_6836_(slot++, this.outputStacks.get(i));
        }
        for (i = 0; i < this.outputFluids.size(); ++i) {
            slots.m_6836_(slot++, (ItemStack)this.outputFluids.get(i).getLeft());
        }
        for (i = 0; i < this.outputChemicals.size(); ++i) {
            slots.m_6836_(slot++, (ItemStack)this.outputChemicals.get(i).getLeft());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.lastGui = new ValueTypeRecipeChemicalLPElementMasterSubGui(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.lastGui;
    }
}

