/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedrest.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedrest.IntegratedRest;
import org.cyclops.integratedrest.api.json.IReverseValueTypeJsonHandler;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandlerRegistry;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.json.handler.CheckedValueTypeJsonHandlerBase;

public class MekanismValueTypeJsonHandlers {
    public static IValueTypeJsonHandlerRegistry REGISTRY = (IValueTypeJsonHandlerRegistry)IntegratedRest._instance.getRegistryManager().getRegistry(IValueTypeJsonHandlerRegistry.class);

    public static void load() {
        REGISTRY.registerHandler((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueChemical");
            if (!value.getRawValue().isEmpty()) {
                ChemicalStack<?> chemicalStack = value.getRawValue();
                if (chemicalStack instanceof GasStack) {
                    jsonObject.addProperty("chemical", JsonUtil.absolutizePath((String)"registry/chemical/mekanism:gas"));
                    jsonObject.addProperty("chemicalName", "mekanism:gas");
                } else if (chemicalStack instanceof InfusionStack) {
                    jsonObject.addProperty("chemical", JsonUtil.absolutizePath((String)"registry/chemical/mekanism:infuse_type"));
                    jsonObject.addProperty("chemicalName", "mekanism:infuse_type");
                } else if (chemicalStack instanceof PigmentStack) {
                    jsonObject.addProperty("chemical", JsonUtil.absolutizePath((String)"registry/chemical/mekanism:pigment"));
                    jsonObject.addProperty("chemicalName", "mekanism:pigment");
                } else if (chemicalStack instanceof SlurryStack) {
                    jsonObject.addProperty("chemical", JsonUtil.absolutizePath((String)"registry/chemical/mekanism:slurry"));
                    jsonObject.addProperty("chemicalName", "mekanism:slurry");
                }
                jsonObject.addProperty("type", JsonUtil.absolutizePath((String)("registry/fluid/" + chemicalStack.getType().getRegistryName().toString())));
                jsonObject.addProperty("typeName", chemicalStack.getType().getRegistryName().toString());
                jsonObject.addProperty("count", (Number)chemicalStack.getAmount());
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler((IReverseValueTypeJsonHandler)new CheckedValueTypeJsonHandlerBase<ValueObjectTypeChemicalStack.ValueChemicalStack>(){

            public ValueObjectTypeChemicalStack.ValueChemicalStack handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueChemical")) {
                    Chemical chemicalType;
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("chemicalName") || !jsonObject.has("typeName")) {
                        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(GasStack.EMPTY);
                    }
                    ForgeRegistry chemicalRegistry = RegistryManager.ACTIVE.getRegistry(ResourceLocation.m_135820_((String)jsonObject.get("chemicalName").getAsString()));
                    if (chemicalRegistry != null && (chemicalType = (Chemical)chemicalRegistry.getValue(ResourceLocation.m_135820_((String)jsonObject.get("typeName").getAsString()))) != null) {
                        long count = 1000L;
                        if (jsonObject.has("count")) {
                            count = jsonObject.get("count").getAsLong();
                        }
                        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(chemicalType.getStack(count));
                    }
                }
                return null;
            }
        });
    }
}

