/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.network;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.radiation.IRadiationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.commoncapabilities.api.ingredient.storage.IngredientComponentStorageEmpty;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageComposite;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.jetbrains.annotations.Nullable;

public class ChemicalNetwork
extends PositionedAddonsNetworkIngredients<ChemicalStack<?>, Integer>
implements IChemicalNetwork {
    public static Capability<? extends IChemicalHandler<?, ?>> ACTIVE_CAPABILITY = null;
    private final LoadingCache<Pair<Capability<? extends IChemicalHandler<?, ?>>, PartPos>, IIngredientComponentStorage<ChemicalStack<?>, Integer>> cacheStorageChemicals = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Capability<? extends IChemicalHandler<?, ?>>, PartPos>, IIngredientComponentStorage<ChemicalStack<?>, Integer>>(){

        public IIngredientComponentStorage<ChemicalStack<?>, Integer> load(Pair<Capability<? extends IChemicalHandler<?, ?>>, PartPos> key) {
            IngredientComponentStorageEmpty storage = ChemicalNetwork.this.getPositionedStorageUnsafe((Capability)key.getLeft(), (PartPos)key.getRight());
            return storage == null ? new IngredientComponentStorageEmpty(ChemicalNetwork.this.getComponent()) : storage;
        }
    });

    public ChemicalNetwork(IngredientComponent<ChemicalStack<?>, Integer> component) {
        super(component);
    }

    public long getRateLimit() {
        return GeneralConfig.chemicalRateLimit;
    }

    @Nullable
    public IIngredientComponentStorage<ChemicalStack<?>, Integer> getPositionedStorageUnsafe(Capability<? extends IChemicalHandler<?, ?>> capability, PartPos pos) {
        DimPos dimPos = pos.getPos();
        Level world = dimPos.getLevel(true);
        if (world == null) {
            return null;
        }
        Optional tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)dimPos.getBlockPos(), BlockEntity.class);
        IIngredientComponentStorageWrapperHandler wrapperHandler = this.getComponent().getStorageWrapperHandler(capability);
        return tile.map(tileEntity -> {
            IChemicalHandler storage = (IChemicalHandler)wrapperHandler.getStorage((ICapabilityProvider)tileEntity, pos.getSide()).orElse(null);
            if (storage == null) {
                return null;
            }
            return wrapperHandler.wrapComponentStorage((Object)storage);
        }).orElse(null);
    }

    public IIngredientComponentStorage<ChemicalStack<?>, Integer> getPositionedStorage(PartPos pos) {
        Capability<? extends IChemicalHandler<?, ?>> capability = ACTIVE_CAPABILITY;
        if (capability != null) {
            try {
                return (IIngredientComponentStorage)this.cacheStorageChemicals.get((Object)Pair.of(capability, (Object)pos));
            }
            catch (ExecutionException e) {
                return new IngredientComponentStorageEmpty(this.getComponent());
            }
        }
        ArrayList storages = Lists.newArrayList();
        for (Capability<? extends IChemicalHandler<?, ?>> capability2 : CapabilityHelpers.CHEMICAL_CAPABILITIES) {
            ACTIVE_CAPABILITY = capability2;
            storages.add(this.getPositionedStorage(pos));
            ACTIVE_CAPABILITY = null;
        }
        return new IngredientComponentStorageComposite(this.getComponent(), (Collection)storages);
    }

    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<ChemicalStack<?>> getPositionedStorageFilter(PartPos pos) {
        PositionedAddonsNetworkIngredientsFilter superFilter = super.getPositionedStorageFilter(pos);
        if (GeneralConfig.transferRadioactiveChemicals || !IRadiationManager.INSTANCE.isRadiationEnabled()) {
            return superFilter;
        }
        return new PositionedAddonsNetworkIngredientsFilter(chemicalStack -> {
            GasAttributes.Radiation attribute = (GasAttributes.Radiation)chemicalStack.get(GasAttributes.Radiation.class);
            return !(attribute != null && attribute.getRadioactivity() != 0.0 || superFilter != null && !superFilter.getFilter().test(chemicalStack));
        }, true, true, superFilter == null || superFilter.isAllowAllIfFilterNotApplied());
    }

    public void update() {
        super.update();
        this.cacheStorageChemicals.invalidateAll();
    }
}

