/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.network.packet;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElement;

public class LogicProgrammerValueTypeRecipeChemicalValueChangedPacket
extends PacketCodec {
    @CodecField
    private String value;
    @CodecField
    private int type;
    @CodecField
    private int slot;

    public LogicProgrammerValueTypeRecipeChemicalValueChangedPacket() {
    }

    public LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(String value, Type type, int slot) {
        this.value = value;
        this.type = type.ordinal();
        this.slot = slot;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ILogicProgrammerElement element;
        if (player.f_36096_ instanceof ContainerLogicProgrammerBase && (element = ((ContainerLogicProgrammerBase)player.f_36096_).getActiveElement()) instanceof ValueTypeRecipeChemicalLPElement) {
            ValueTypeRecipeChemicalLPElement elementCast = (ValueTypeRecipeChemicalLPElement)element;
            Type type = Type.values()[this.type];
            switch (type) {
                case INPUT_FLUID: {
                    elementCast.getInputFluids().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getInputFluids().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case INPUT_CHEMICAL: {
                    elementCast.getInputChemicals().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getInputChemicals().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case OUTPUT_FLUID: {
                    elementCast.getOutputFluids().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getOutputFluids().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case OUTPUT_CHEMICAL: {
                    elementCast.getOutputChemicals().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getOutputChemicals().get(this.slot).getLeft()), (Object)this.value));
                }
            }
            ((ContainerLogicProgrammerBase)player.f_36096_).onDirty();
        }
    }

    public static enum Type {
        INPUT_FLUID,
        INPUT_CHEMICAL,
        OUTPUT_FLUID,
        OUTPUT_CHEMICAL;

    }
}

