/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import mekanism.common.registries.MekanismGases;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.operator.MekanismOperators;
import org.cyclops.integratedmekanism.test.Asserts;
import org.cyclops.integratedmekanism.test.DummyValueType;
import org.cyclops.integratedmekanism.test.DummyVariable;
import org.cyclops.integratedmekanism.test.DummyVariableIngredients;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class TestIngredientsOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariable<ValueTypeInteger.ValueInteger> i0;
    private DummyVariable<ValueTypeInteger.ValueInteger> i1;
    private DummyVariable<ValueTypeInteger.ValueInteger> i2;
    private DummyVariable<ValueTypeInteger.ValueInteger> i3;
    private DummyVariableIngredients iChemicals;
    private DummyVariable<ValueTypeList.ValueList> lChemicals;
    private IMixedIngredients inputIngredients;
    private DummyVariableIngredients iMix;
    private DummyVariable<ValueObjectTypeChemicalStack.ValueChemicalStack> iChemical;

    @IntegrationBefore
    public void before() {
        this.i0 = new DummyVariable<ValueTypeInteger.ValueInteger>((IValueType<ValueTypeInteger.ValueInteger>)ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of((int)0));
        this.i1 = new DummyVariable<ValueTypeInteger.ValueInteger>((IValueType<ValueTypeInteger.ValueInteger>)ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of((int)1));
        this.i2 = new DummyVariable<ValueTypeInteger.ValueInteger>((IValueType<ValueTypeInteger.ValueInteger>)ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of((int)2));
        this.i3 = new DummyVariable<ValueTypeInteger.ValueInteger>((IValueType<ValueTypeInteger.ValueInteger>)ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of((int)3));
        this.iChemicals = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (Collection)Lists.newArrayList((Object[])new ChemicalStack[]{new GasStack((IGasProvider)MekanismGases.STEAM, 1000L), new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L)}))));
        this.lChemicals = new DummyVariable<ValueTypeList.ValueList>((IValueType<ValueTypeList.ValueList>)ValueTypes.LIST, ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L))}));
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        ingredients.put(IngredientComponent.ENERGY, Lists.newArrayList((Object[])new Long[]{777L}));
        ingredients.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new GasStack[]{new GasStack((IGasProvider)MekanismGases.HYDROGEN, 125L)}));
        ingredients.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42453_), new ItemStack((ItemLike)Item.m_41439_((Block)Blocks.f_50069_))}));
        this.inputIngredients = new MixedIngredients((Map)ingredients);
        this.iMix = new DummyVariableIngredients(ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)this.inputIngredients));
        this.iChemical = new DummyVariable<ValueObjectTypeChemicalStack.ValueChemicalStack>((IValueType<ValueObjectTypeChemicalStack.ValueChemicalStack>)MekanismValueTypes.OBJECT_CHEMICALSTACK, ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L)));
    }

    @IntegrationTest
    public void testChemicals() throws EvaluationException {
        IValue res1 = MekanismOperators.INGREDIENTS_CHEMICALS.evaluate(new IVariable[]{this.iChemicals});
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual((Object)((ValueTypeList.ValueList)res1).getRawValue().getLength(), (Object)2, (String)"chemicals(chemicals, 0).size = 2");
        TestHelpers.assertEqual((Object)res1, (Object)ValueTypeList.ValueList.ofList((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (List)Lists.newArrayList((Object[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L))})), (String)"chemicals(chemicals) = lava, water");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testChemicalsSizeLarge() throws EvaluationException {
        MekanismOperators.INGREDIENTS_CHEMICALS.evaluate(new IVariable[]{this.iMix, this.i0});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testChemicalsSizeSmall() throws EvaluationException {
        MekanismOperators.INGREDIENTS_CHEMICALS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testChemicalsSize() throws EvaluationException {
        MekanismOperators.INGREDIENTS_CHEMICALS.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testWithChemical() throws EvaluationException {
        IValue res1 = MekanismOperators.INGREDIENTS_WITH_CHEMICAL.evaluate(new IVariable[]{this.iMix, this.i0, this.iChemical});
        Asserts.check(res1 instanceof ValueObjectTypeIngredients.ValueIngredients, "result is an ingredient");
        IMixedIngredients outputIngredients1 = (IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)res1).getRawValue().get();
        List outputList1 = outputIngredients1.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK);
        TestHelpers.assertEqual((Object)outputList1.size(), (Object)1, (String)"with_chemicals(mix, 0, chemicals)[0]size = 1");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList1.get(0)), (Object)new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L), (String)"with_chemicals(mix, 0, chemicals)[0] = chemicals[0]");
        TestHelpers.assertEqual((Object)outputIngredients1.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).size(), (Object)this.inputIngredients.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).size(), (String)"Chemicals size remains the same");
        TestHelpers.assertNonEqual((Object)((Object)ValueObjectTypeChemicalStack.ValueChemicalStack.of((ChemicalStack)outputIngredients1.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0))), (Object)((Object)ValueObjectTypeChemicalStack.ValueChemicalStack.of((ChemicalStack)this.inputIngredients.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0))), (String)"Chemicals 0 changes");
        TestHelpers.assertEqual((Object)outputIngredients1.getInstances(IngredientComponent.ITEMSTACK), (Object)this.inputIngredients.getInstances(IngredientComponent.ITEMSTACK), (String)"Items remains the same");
        TestHelpers.assertEqual((Object)outputIngredients1.getInstances(IngredientComponent.ENERGY), (Object)this.inputIngredients.getInstances(IngredientComponent.ENERGY), (String)"Energy remains the same");
        IValue res2 = MekanismOperators.INGREDIENTS_WITH_CHEMICAL.evaluate(new IVariable[]{this.iMix, this.i2, this.iChemical});
        IMixedIngredients outputIngredients2 = (IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)res2).getRawValue().get();
        List outputList2 = outputIngredients2.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK);
        TestHelpers.assertEqual((Object)outputList2.size(), (Object)3, (String)"with_chemicals(mix, 3, chemicals)[0]size = 2");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList2.get(0)), (Object)new GasStack((IGasProvider)MekanismGases.HYDROGEN, 125L), (String)"with_chemicals(mix, 2, chemicals)[0] = chemicals[0]");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList2.get(1)), (Object)GasStack.EMPTY, (String)"with_chemicals(mix, 2, chemicals)[1] = chemicals[1]");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList2.get(2)), (Object)new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L), (String)"with_chemicals(mix, 2, chemicals)[2] = chemicals[2]");
        TestHelpers.assertNonEqual((Object)outputIngredients2.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).size(), (Object)this.inputIngredients.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).size(), (String)"Chemicals size changes");
        TestHelpers.assertNonEqual(outputIngredients2.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(2), Collections.emptyList(), (String)"Chemicals 3 is not empty");
        TestHelpers.assertEqual((Object)outputIngredients2.getInstances(IngredientComponent.ITEMSTACK), (Object)this.inputIngredients.getInstances(IngredientComponent.ITEMSTACK), (String)"Items remains the same");
        TestHelpers.assertEqual((Object)outputIngredients2.getInstances(IngredientComponent.ENERGY), (Object)this.inputIngredients.getInstances(IngredientComponent.ENERGY), (String)"Energy remains the same");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalSizeLarge() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICAL.evaluate(new IVariable[]{this.iMix, this.i0, this.iChemical});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalSizeSmall() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICAL.evaluate(new IVariable[]{this.iMix, this.i0});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalSize() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICAL.evaluate(new IVariable[]{DUMMY_VARIABLE, DUMMY_VARIABLE, DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testWithChemicals() throws EvaluationException {
        IValue res1 = MekanismOperators.INGREDIENTS_WITH_CHEMICALS.evaluate(new IVariable[]{this.iMix, this.lChemicals});
        Asserts.check(res1 instanceof ValueObjectTypeIngredients.ValueIngredients, "result is an ingredient");
        IMixedIngredients outputIngredients1 = (IMixedIngredients)((ValueObjectTypeIngredients.ValueIngredients)res1).getRawValue().get();
        List outputList1 = outputIngredients1.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK);
        TestHelpers.assertEqual((Object)outputList1.size(), (Object)2, (String)"with_chemicals(mix, chemicals)[0]size = 2");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList1.get(0)), (Object)new GasStack((IGasProvider)MekanismGases.STEAM, 1000L), (String)"with_chemicals(mix, chemicals)[0] = chemicals[0]");
        TestHelpers.assertEqual((Object)((ChemicalStack)outputList1.get(1)), (Object)new GasStack((IGasProvider)MekanismGases.HYDROGEN, 123L), (String)"with_chemicals(mix, chemicals)[1] = chemicals[1]");
        TestHelpers.assertEqual((Object)outputIngredients1.getInstances(IngredientComponent.ITEMSTACK), (Object)this.inputIngredients.getInstances(IngredientComponent.ITEMSTACK), (String)"Item remains the same");
        TestHelpers.assertEqual((Object)outputIngredients1.getInstances(IngredientComponent.ENERGY), (Object)this.inputIngredients.getInstances(IngredientComponent.ENERGY), (String)"Energy remains the same");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalsSizeLarge() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICALS.evaluate(new IVariable[]{this.iMix, this.lChemicals});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalsSizeSmall() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICALS.evaluate(new IVariable[]{this.iMix});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testWithChemicalsSize() throws EvaluationException {
        MekanismOperators.INGREDIENTS_WITH_CHEMICALS.evaluate(new IVariable[]{DUMMY_VARIABLE, DUMMY_VARIABLE});
    }
}

