/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.integratedmekanism.IntegratedMekanism;
import org.cyclops.integratedmekanism.capability.chemicalhandler.VanillaEntityItemChemicalHandler;
import org.cyclops.integratedmekanism.capability.chemicalhandler.VanillaEntityItemFrameChemicalHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalCrystallizerRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalDissolutionRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.CombinerRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.FluidChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.FluidToFluidRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemChemicalToItemRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemToItemRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.PressurizedReactionRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.RotaryRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.SawmillRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.SeparatingRecipeHandler;
import org.cyclops.integratedmekanism.capability.temperature.FissionReactorTemperature;
import org.cyclops.integratedmekanism.capability.worker.FissionReactorWorker;

public class MekanismCapabilityLoader {
    public static void load() {
        CapabilityConstructorRegistry registry = IntegratedMekanism._instance.getCapabilityConstructorRegistry();
        registry.registerBlockEntity((Supplier)GeneratorsTileEntityTypes.FISSION_REACTOR_LOGIC_ADAPTER, (ICapabilityConstructor)new ICapabilityConstructor<TileEntityFissionReactorLogicAdapter, Direction, IWorker, BlockEntityType<TileEntityFissionReactorLogicAdapter>>(){

            public BaseCapability<IWorker, Direction> getCapability() {
                return Capabilities.Worker.BLOCK;
            }

            public ICapabilityProvider<TileEntityFissionReactorLogicAdapter, Direction, IWorker> createProvider(BlockEntityType<TileEntityFissionReactorLogicAdapter> tBlockEntityType) {
                return (blockEntity, side) -> new FissionReactorWorker((TileEntityFissionReactorLogicAdapter)blockEntity);
            }
        });
        registry.registerBlockEntity((Supplier)GeneratorsTileEntityTypes.FISSION_REACTOR_LOGIC_ADAPTER, (ICapabilityConstructor)new ICapabilityConstructor<TileEntityFissionReactorLogicAdapter, Direction, ITemperature, BlockEntityType<TileEntityFissionReactorLogicAdapter>>(){

            public BaseCapability<ITemperature, Direction> getCapability() {
                return Capabilities.Temperature.BLOCK;
            }

            public ICapabilityProvider<TileEntityFissionReactorLogicAdapter, Direction, ITemperature> createProvider(BlockEntityType<TileEntityFissionReactorLogicAdapter> tBlockEntityType) {
                return (blockEntity, side) -> new FissionReactorTemperature((TileEntityFissionReactorLogicAdapter)blockEntity);
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> MekanismRecipeHandler.CACHED_RECIPES.clear());
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CRUSHER, MekanismRecipeType.CRUSHING, FactoryType.CRUSHING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ItemStackToItemStackRecipe, ?>)MekanismRecipeType.CRUSHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ENRICHMENT_CHAMBER, MekanismRecipeType.ENRICHING, FactoryType.ENRICHING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ItemStackToItemStackRecipe, ?>)MekanismRecipeType.ENRICHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ENERGIZED_SMELTER, MekanismRecipeType.SMELTING, FactoryType.SMELTING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ItemStackToItemStackRecipe, ?>)MekanismRecipeType.SMELTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_INFUSER, MekanismRecipeType.CHEMICAL_INFUSING, null, level -> new ChemicalChemicalToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ChemicalChemicalToChemicalRecipe, ?>)MekanismRecipeType.CHEMICAL_INFUSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.COMBINER, MekanismRecipeType.COMBINING, FactoryType.COMBINING, CombinerRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ELECTROLYTIC_SEPARATOR, MekanismRecipeType.SEPARATING, null, SeparatingRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_WASHER, MekanismRecipeType.WASHING, null, level -> new FluidChemicalToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends FluidChemicalToChemicalRecipe, ?>)MekanismRecipeType.WASHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.THERMAL_EVAPORATION_CONTROLLER, MekanismRecipeType.EVAPORATING, null, level -> new FluidToFluidRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends FluidToFluidRecipe, ?>)MekanismRecipeType.EVAPORATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.THERMAL_EVAPORATION_VALVE, MekanismRecipeType.EVAPORATING, null, level -> new FluidToFluidRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends FluidToFluidRecipe, ?>)MekanismRecipeType.EVAPORATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.SOLAR_NEUTRON_ACTIVATOR, MekanismRecipeType.ACTIVATING, null, level -> new ChemicalToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ChemicalToChemicalRecipe, ?>)MekanismRecipeType.ACTIVATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ISOTOPIC_CENTRIFUGE, MekanismRecipeType.CENTRIFUGING, null, level -> new ChemicalToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ChemicalToChemicalRecipe, ?>)MekanismRecipeType.CENTRIFUGING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_CRYSTALLIZER, MekanismRecipeType.CRYSTALLIZING, null, ChemicalCrystallizerRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_DISSOLUTION_CHAMBER, MekanismRecipeType.DISSOLUTION, null, ChemicalDissolutionRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.OSMIUM_COMPRESSOR, MekanismRecipeType.COMPRESSING, FactoryType.COMPRESSING, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.COMPRESSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PURIFICATION_CHAMBER, MekanismRecipeType.PURIFYING, FactoryType.PURIFYING, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.PURIFYING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_INJECTION_CHAMBER, MekanismRecipeType.INJECTING, FactoryType.INJECTING, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.INJECTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ANTIPROTONIC_NUCLEOSYNTHESIZER, MekanismRecipeType.NUCLEOSYNTHESIZING, null, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.NUCLEOSYNTHESIZING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.CHEMICAL_OXIDIZER, MekanismRecipeType.OXIDIZING, null, level -> new ItemToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackToChemicalRecipe, ?>)MekanismRecipeType.OXIDIZING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PIGMENT_EXTRACTOR, MekanismRecipeType.PIGMENT_EXTRACTING, null, level -> new ItemToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackToChemicalRecipe, ?>)MekanismRecipeType.PIGMENT_EXTRACTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PIGMENT_MIXER, MekanismRecipeType.PIGMENT_MIXING, null, level -> new ChemicalChemicalToChemicalRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ChemicalChemicalToChemicalRecipe, ?>)MekanismRecipeType.PIGMENT_MIXING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.METALLURGIC_INFUSER, MekanismRecipeType.METALLURGIC_INFUSING, FactoryType.INFUSING, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.METALLURGIC_INFUSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PAINTING_MACHINE, MekanismRecipeType.PAINTING, null, level -> new ItemChemicalToItemRecipeHandler((IMekanismRecipeTypeProvider<?, ? extends ItemStackChemicalToItemStackRecipe, ?>)MekanismRecipeType.PAINTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PRESSURIZED_REACTION_CHAMBER, MekanismRecipeType.REACTION, null, PressurizedReactionRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.ROTARY_CONDENSENTRATOR, MekanismRecipeType.ROTARY, null, RotaryRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, MekanismTileEntityTypes.PRECISION_SAWMILL, MekanismRecipeType.SAWING, FactoryType.SAWING, SawmillRecipeHandler::new);
        registry.registerEntity(() -> EntityType.ITEM, (ICapabilityConstructor)new ICapabilityConstructor<ItemEntity, Direction, IChemicalHandler, EntityType<ItemEntity>>(){

            public BaseCapability<IChemicalHandler, Direction> getCapability() {
                return Capabilities.CHEMICAL.entity();
            }

            public ICapabilityProvider<ItemEntity, Direction, IChemicalHandler> createProvider(EntityType<ItemEntity> capabilityKey) {
                return (entity, context) -> {
                    if (entity.getItem().getCapability(Capabilities.CHEMICAL.item()) != null) {
                        return new VanillaEntityItemChemicalHandler((ItemEntity)entity);
                    }
                    return null;
                };
            }
        });
        registry.registerEntity(() -> EntityType.ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<ItemFrame, Direction, IChemicalHandler, EntityType<ItemFrame>>(){

            public BaseCapability<IChemicalHandler, Direction> getCapability() {
                return Capabilities.CHEMICAL.entity();
            }

            public ICapabilityProvider<ItemFrame, Direction, IChemicalHandler> createProvider(EntityType<ItemFrame> capabilityKey) {
                return (entity, context) -> {
                    if (entity.getItem().getCapability(Capabilities.CHEMICAL.item()) != null) {
                        return new VanillaEntityItemFrameChemicalHandler((ItemFrame)entity);
                    }
                    return null;
                };
            }
        });
        registry.registerEntity(() -> EntityType.GLOW_ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<GlowItemFrame, Direction, IChemicalHandler, EntityType<GlowItemFrame>>(){

            public BaseCapability<IChemicalHandler, Direction> getCapability() {
                return Capabilities.CHEMICAL.entity();
            }

            public ICapabilityProvider<GlowItemFrame, Direction, IChemicalHandler> createProvider(EntityType<GlowItemFrame> capabilityKey) {
                return (entity, context) -> {
                    if (entity.getItem().getCapability(Capabilities.CHEMICAL.item()) != null) {
                        return new VanillaEntityItemFrameChemicalHandler((ItemFrame)entity);
                    }
                    return null;
                };
            }
        });
    }

    protected static <T extends BlockEntity> void addRecipeHandler(CapabilityConstructorRegistry registry, Supplier<BlockEntityType<T>> blockEntityType, IMekanismRecipeTypeProvider<?, ?, ?> recipeType, @Nullable FactoryType factoryType, final Function<Supplier<Level>, IRecipeHandler> recipeHandlerConstructor) {
        registry.registerBlockEntity(blockEntityType, new ICapabilityConstructor<T, Direction, IRecipeHandler, BlockEntityType<T>>(){

            public BaseCapability<IRecipeHandler, Direction> getCapability() {
                return Capabilities.RecipeHandler.BLOCK;
            }

            public ICapabilityProvider<T, Direction, IRecipeHandler> createProvider(BlockEntityType<T> tBlockEntityType) {
                return (blockEntity, side) -> (IRecipeHandler)recipeHandlerConstructor.apply(() -> ((BlockEntity)blockEntity).getLevel());
            }
        });
        if (factoryType != null) {
            for (FactoryTier factoryTier : FactoryTier.values()) {
                registry.registerBlockEntity(() -> (BlockEntityType)MekanismTileEntityTypes.getFactoryTile((FactoryTier)factoryTier, (FactoryType)factoryType).get(), (ICapabilityConstructor)new ICapabilityConstructor<TileEntityFactory, Direction, IRecipeHandler, BlockEntityType<TileEntityFactory>>(){

                    public BaseCapability<IRecipeHandler, Direction> getCapability() {
                        return Capabilities.RecipeHandler.BLOCK;
                    }

                    public ICapabilityProvider<TileEntityFactory, Direction, IRecipeHandler> createProvider(BlockEntityType<TileEntityFactory> tBlockEntityType) {
                        return (blockEntity, side) -> (IRecipeHandler)recipeHandlerConstructor.apply(() -> ((TileEntityFactory)blockEntity).getLevel());
                    }
                });
            }
        }
    }
}

