/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

public class RotaryRecipeHandler
extends MekanismRecipeHandler<RotaryRecipe> {
    private boolean fluidToChemical;

    protected RotaryRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.ROTARY, levelSupplier, Set.of(IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.FLUIDSTACK && size <= 1 || ingredientComponent == MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK && size <= 1;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipesUncached() {
        ArrayList list = Lists.newArrayList();
        this.fluidToChemical = true;
        list.addAll(super.getRecipesUncached());
        this.fluidToChemical = false;
        list.addAll(super.getRecipesUncached());
        return list;
    }

    @Override
    protected boolean isValid(RecipeHolder<? extends RotaryRecipe> recipeHolder) {
        return super.isValid(recipeHolder) && (this.fluidToChemical ? ((RotaryRecipe)recipeHolder.value()).hasFluidToChemical() : ((RotaryRecipe)recipeHolder.value()).hasChemicalToFluid());
    }

    @Override
    protected void recipeToInputs(RotaryRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        if (recipe.hasFluidToChemical() && this.fluidToChemical) {
            inputs.put(IngredientComponents.FLUIDSTACK, List.of(new PrototypedIngredientAlternativesList(RotaryRecipeHandler.getPrototypesFromFluidIngredient((InputIngredient<FluidStack>)recipe.getFluidInput()))));
        }
        if (recipe.hasChemicalToFluid() && !this.fluidToChemical) {
            inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, List.of(new PrototypedIngredientAlternativesList(RotaryRecipeHandler.getPrototypesFromChemicalIngredient(recipe.getChemicalInput()))));
        }
    }

    @Override
    protected void recipeToOutputs(RotaryRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        if (recipe.hasFluidToChemical() && this.fluidToChemical) {
            outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new ChemicalStack[]{(ChemicalStack)recipe.getChemicalOutputDefinition().get(0)}));
        }
        if (recipe.hasChemicalToFluid() && !this.fluidToChemical) {
            outputs.put(IngredientComponents.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{(FluidStack)recipe.getFluidOutputDefinition().get(0)}));
        }
    }

    @Override
    protected void recipeToOutputsSimulated(RotaryRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        if (recipe.hasFluidToChemical() && !input.getInstances(IngredientComponents.FLUIDSTACK).isEmpty()) {
            outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new ChemicalStack[]{recipe.getChemicalOutput((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0))}));
        }
        if (recipe.hasChemicalToFluid() && !input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).isEmpty()) {
            outputs.put(IngredientComponents.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getFluidOutput((ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0))}));
        }
    }

    @Override
    protected boolean doesRecipeMatchInput(RotaryRecipe recipe, IMixedIngredients input) {
        return recipe.getFluidInput().test((FluidStack)input.getFirstNonEmpty(IngredientComponents.FLUIDSTACK)) || recipe.getChemicalInput().test((ChemicalStack)input.getFirstNonEmpty(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK));
    }
}

