/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest.integration;

import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integratedmekanism.gametest.integration.Asserts;
import org.cyclops.integratedmekanism.gametest.integration.DummyValueType;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariable;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariableEntity;
import org.cyclops.integratedmekanism.gametest.integration.ValueEntityMock;
import org.cyclops.integratedmekanism.operator.MekanismOperators;

public class TestEntityOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableEntity eZombie;

    protected ValueObjectTypeEntity.ValueEntity makeEntity(Entity entity) {
        return new ValueEntityMock(entity);
    }

    @IntegrationBefore
    public void before() {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD);
        this.eZombie = new DummyVariableEntity(this.makeEntity((Entity)new Zombie((Level)world)));
    }

    @IntegrationTest
    public void testEntityRadiation() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_ENTITY_RADIATION.evaluate(new IVariable[]{this.eZombie});
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        org.apache.http.util.Asserts.check((boolean)Objects.equals(((ValueTypeDouble.ValueDouble)res1).getRawValue(), 1.0E-7), (String)"radiation(zombie) = 1.0E-7");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testEntityRadiationLarge() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(new IVariable[]{this.eZombie, this.eZombie});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testEntityRadiationSmall() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeEntityRadiation() throws EvaluationException {
        Operators.OBJECT_ENTITY_ISMOB.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }
}

