/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.ingredient;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.integratedmekanism.core.ChemicalHelpers;
import org.cyclops.integratedmekanism.ingredient.ChemicalMatch;

public class IngredientMatcherChemicalStack
implements IIngredientMatcher<ChemicalStack, Integer> {
    public boolean isInstance(Object object) {
        return object instanceof ChemicalStack;
    }

    public Integer getAnyMatchCondition() {
        return 0;
    }

    public Integer getExactMatchCondition() {
        return 3;
    }

    public Integer getExactMatchNoQuantityCondition() {
        return 1;
    }

    public Integer withCondition(Integer matchCondition, Integer with) {
        return matchCondition | with;
    }

    public Integer withoutCondition(Integer matchCondition, Integer without) {
        return matchCondition & ~without.intValue();
    }

    public boolean hasCondition(Integer matchCondition, Integer searchCondition) {
        return (matchCondition & searchCondition) > 0;
    }

    public int hash(ChemicalStack instance) {
        if (instance.isEmpty()) {
            return 0;
        }
        int code = 1;
        code = 31 * code + instance.getChemical().hashCode();
        code = 31 * code + Long.hashCode(instance.getAmount());
        return code;
    }

    public ChemicalStack copy(ChemicalStack instance) {
        if (instance.isEmpty()) {
            return this.getEmptyInstance();
        }
        return instance.copy();
    }

    public long getQuantity(ChemicalStack instance) {
        return instance.getAmount();
    }

    public boolean matches(ChemicalStack a, ChemicalStack b, Integer matchCondition) {
        return ChemicalMatch.areStacksEqual(a, b, matchCondition);
    }

    public ChemicalStack getEmptyInstance() {
        return ChemicalStack.EMPTY;
    }

    public boolean isEmpty(ChemicalStack instance) {
        return instance.isEmpty();
    }

    public ChemicalStack withQuantity(ChemicalStack instance, long quantity) {
        if (quantity == 0L) {
            return this.getEmptyInstance();
        }
        if (instance.isEmpty()) {
            Chemical someType = (Chemical)ChemicalHelpers.getStackRegistry().iterator().next();
            return someType.getStack(quantity);
        }
        if (instance.getAmount() == quantity) {
            return instance;
        }
        ChemicalStack copy = instance.copy();
        copy.setAmount(quantity);
        return copy;
    }

    public long getMaximumQuantity() {
        return Long.MAX_VALUE;
    }

    public int conditionCompare(Integer a, Integer b) {
        return Integer.compare(a, b);
    }

    public String localize(ChemicalStack instance) {
        return instance.getTextComponent().getString();
    }

    public MutableComponent getDisplayName(ChemicalStack instance) {
        return instance.getTextComponent().plainCopy();
    }

    public String toString(ChemicalStack instance) {
        DefaultedRegistry<Chemical> registry = ChemicalHelpers.getStackRegistry();
        return String.format("%s %s", registry.getKey((Object)instance.getChemical()), instance.getAmount());
    }

    public int compare(ChemicalStack o1, ChemicalStack o2) {
        if (o1.isEmpty()) {
            if (o2.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (o2.isEmpty()) {
            return 1;
        }
        if (o1.getChemical() == o2.getChemical()) {
            return (int)(o1.getAmount() - o2.getAmount());
        }
        return o1.getChemical().getRegistryName().compareTo(o2.getChemical().getRegistryName());
    }
}

