/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedrest.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedrest.IntegratedRest;
import org.cyclops.integratedrest.api.json.IReverseValueTypeJsonHandler;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandlerRegistry;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.json.handler.CheckedValueTypeJsonHandlerBase;

public class MekanismValueTypeJsonHandlers {
    public static IValueTypeJsonHandlerRegistry REGISTRY = (IValueTypeJsonHandlerRegistry)IntegratedRest._instance.getRegistryManager().getRegistry(IValueTypeJsonHandlerRegistry.class);

    public static void load() {
        REGISTRY.registerHandler((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueChemical");
            if (!value.getRawValue().isEmpty()) {
                ChemicalStack chemicalStack = value.getRawValue();
                String name = MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)chemicalStack.getChemical()).toString();
                jsonObject.addProperty("chemical", JsonUtil.absolutizePath((String)("registry/chemical/" + name)));
                jsonObject.addProperty("chemicalName", name);
                jsonObject.addProperty("count", (Number)chemicalStack.getAmount());
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler((IReverseValueTypeJsonHandler)new CheckedValueTypeJsonHandlerBase<ValueObjectTypeChemicalStack.ValueChemicalStack>(){

            public ValueObjectTypeChemicalStack.ValueChemicalStack handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueChemical")) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("chemicalName")) {
                        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(ChemicalStack.EMPTY);
                    }
                    Chemical chemicalType = (Chemical)MekanismAPI.CHEMICAL_REGISTRY.get(ResourceLocation.tryParse((String)jsonObject.get("typeName").getAsString()));
                    if (chemicalType != null) {
                        long count = 1000L;
                        if (jsonObject.has("count")) {
                            count = jsonObject.get("count").getAsLong();
                        }
                        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(chemicalType.getStack(count));
                    }
                }
                return null;
            }
        });
    }
}

