package net.levente;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.levente.datagen.*;
import net.levente.world.ModConfiguredFeatures;
import net.levente.world.ModPlacedFeatures;
import net.minecraft.class_173;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class ComeHomeDataGenerator implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();

        pack.addProvider(ModLangProvider::new);
        pack.addProvider(ModModelProvider::new);
        pack.addProvider(ModBlockTagProvider::new);
        pack.addProvider(ModBlockLootTableProvider::new);
        pack.addProvider(ModRegistryDataGenerator::new);
        pack.addProvider(ModRecipeProvider::new);
        pack.addProvider((output, registries) ->
                new ModChestLootTableProvider(output, registries, class_173.field_1179));
	}

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, ModConfiguredFeatures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, ModPlacedFeatures::bootstrap);
    }
}
