package net.levente.mixin;

import net.levente.event.custom.ItemPickupCallback;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1542.class)
public class ItemPickupMixin {
    @Inject(method = "onPlayerCollision",
    at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/ItemEntity;getStack()Lnet/minecraft/item/ItemStack;"))
    private void firePickupEvent(class_1657 player, CallbackInfo ci) {
        class_1542 self = (class_1542)(Object)this;
        class_1799 stack = self.method_6983();
        int count = stack.method_7947();

        ItemPickupCallback.EVENT.invoker().onPickup(player, self, stack, count);
    }

}
