package net.ppekkungz.npotMethod.compact.sodium.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import net.minecraft.class_310;
import net.ppekkungz.npotMethod.NPotFixer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value = SodiumGameOptionPages.class, remap = false)
abstract class SodiumGameOptionPagesMixin {

    @SuppressWarnings("unchecked")
    @WrapOperation(method = "quality", at = @At(value = "INVOKE", target = "Lme/jellysquid/mods/sodium/client/gui/options/OptionImpl$Builder;build()Lme/jellysquid/mods/sodium/client/gui/options/OptionImpl;"), remap = false)
    private static <S, T> OptionImpl<S, T> increaseMipmapLevels(OptionImpl.Builder builder, Operation<OptionImpl<S, T>> factory){
        OptionImpl<S, T> option = factory.call(builder);
        if(!option.getName().getString().equals(class_310.method_1551().field_1690.method_42563().toString()))
            return option;
        return builder
                .setControl(o -> new SliderControl((Option<Integer>) o, 0, NPotFixer.MAX_MIPMAP_LEVEL, 1, ControlValueFormatter.multiplier()))
                .build();
    }

}