package net.ppekkungz.npotMethod.mixin;

import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.ppekkungz.npotMethod.NPotFixer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

@Mixin(class_7766.class)
public class SpriteLoaderMixin {

    @Inject(method = "loadSprite", at = @At("RETURN"), cancellable = true)
    private static void upscaleSprite(class_2960 resourceLocation, class_3298 resource, CallbackInfoReturnable<class_7764> cir) {
        class_7764 contents = cir.getReturnValue();
        if (contents == null) return;

        try {
            int width = contents.method_45807();
            int height = contents.method_45815();

            // TODO: Check if texture dimensions are not power of two
            boolean isWidthNotPowerOfTwo = !isPowerOfTwo(width);
            boolean isHeightNotPowerOfTwo = !isPowerOfTwo(height);

            if (isWidthNotPowerOfTwo || isHeightNotPowerOfTwo) {
                NPotFixer.LOGGER.debug("Found texture with non-power-of-two dimensions: {} ({}x{})",
                        resourceLocation, width, height);
            }

            if (!NPotFixer.UPSCALE_WHITELIST.contains(resourceLocation)) return;
            if (width >= 32 && height >= 32) return;

            class_1011 original = getOriginalImage(contents);
            if (original == null) return;

            NPotFixer.LOGGER.debug("Upscaling sprite: {} from {}x{} to 32x32", resourceLocation, width, height);

            class_1011 upscaled = upscaleNativeImageBilinear(original, 32, 32);
            class_7764 newContents = createNewSpriteContents(contents, resourceLocation, upscaled);
            cir.setReturnValue(newContents);

        } catch (Exception e) {
            System.err.println("Failed to upscale sprite: " + resourceLocation + " - " + e.getMessage());
        }
    }

    private static class_1011 getOriginalImage(class_7764 contents) {
        try {
            // TODO: Try common field names for different MC versions
            String[] possibleFieldNames = {
                    "originalImage", "image", "nativeImage", "texture",
                    "byMipLevel", "mipmapImages", "f_118364_", "f_244209_"
            };

            for (String fieldName : possibleFieldNames) {
                try {
                    Field field = contents.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object value = field.get(contents);

                    if (value instanceof class_1011) {
                        return (class_1011) value;
                    } else if (value instanceof class_1011[]) {
                        class_1011[] images = (class_1011[]) value;
                        if (images.length > 0 && images[0] != null) {
                            return images[0];
                        }
                    }
                } catch (NoSuchFieldException ignored) {}
            }

            // TODO: Fallback - scan all fields for NativeImage type
            Field[] fields = contents.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(contents);
                if (value instanceof class_1011) {
                    return (class_1011) value;
                } else if (value instanceof class_1011[]) {
                    class_1011[] images = (class_1011[]) value;
                    if (images.length > 0 && images[0] != null) {
                        return images[0];
                    }
                }
            }

            return null;
        } catch (Exception e) {
            return null;
        }
    }

    private static class_7764 createNewSpriteContents(class_7764 original, class_2960 id, class_1011 upscaled) {
        try {
            Constructor<?>[] constructors = class_7764.class.getConstructors();
            java.util.Arrays.sort(constructors, (a, b) -> Integer.compare(a.getParameterCount(), b.getParameterCount()));

            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] args = new Object[constructor.getParameterCount()];
                    Class<?>[] paramTypes = constructor.getParameterTypes();

                    // TODO: Match parameter types with appropriate values
                    for (int i = 0; i < paramTypes.length; i++) {
                        if (paramTypes[i] == class_2960.class) {
                            args[i] = id;
                        } else if (paramTypes[i] == class_1011.class) {
                            args[i] = upscaled;
                        } else if (paramTypes[i] == int.class) {
                            args[i] = (i < 3) ? upscaled.method_4307() : upscaled.method_4323();
                        } else if (paramTypes[i] == boolean.class) {
                            args[i] = false;
                        } else {
                            args[i] = getFieldOfType(original, paramTypes[i]);
                        }
                    }

                    return (class_7764) constructor.newInstance(args);

                } catch (Exception ignored) {}
            }

            throw new RuntimeException("No suitable constructor found for SpriteContents");

        } catch (Exception e) {
            throw new RuntimeException("Failed to create new SpriteContents", e);
        }
    }

    private static Object getFieldOfType(Object obj, Class<?> type) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                if (type.isAssignableFrom(field.getType())) {
                    return field.get(obj);
                }
            }
        } catch (Exception ignored) {}
        return null;
    }

    private static class_1011 upscaleNativeImageBilinear(class_1011 original, int newWidth, int newHeight) throws IOException {
        BufferedImage bufferedOriginal = nativeImageToBufferedImage(original);
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, BufferedImage.TYPE_INT_ARGB);

        Graphics2D g2d = scaledImage.createGraphics();
        try {
            // TODO: High-quality bilinear interpolation settings
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);

            g2d.drawImage(bufferedOriginal, 0, 0, newWidth, newHeight, null);
        } finally {
            g2d.dispose();
        }

        return bufferedImageToNativeImage(scaledImage);
    }

    private static BufferedImage nativeImageToBufferedImage(class_1011 nativeImage) {
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);

        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                bufferedImage.setRGB(x, y, nativeImage.method_4315(x, y));
            }
        }

        return bufferedImage;
    }

    private static class_1011 bufferedImageToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);

        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                nativeImage.method_4305(x, y, bufferedImage.getRGB(x, y));
            }
        }

        return nativeImage;
    }

    // TODO: Helper method to check if a number is power of two
    private static boolean isPowerOfTwo(int n) {
        return n > 0 && (n & (n - 1)) == 0;
    }
}