/*
 * Decompiled with CFR 0.152.
 */
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BoneToolUseEvent {
    private static final int DURABILITY_COST = 30;
    private static final int SHIELD_DURATION = 200;
    private static final Map<UUID, Long> activeShields = new HashMap<UUID, Long>();
    private static final Map<UUID, List<class_1297>> playerBones = new HashMap<UUID, List<class_1297>>();

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1831 toolItem;
            class_1792 patt0$temp;
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430((Object)stack);
            }
            if (player.method_5715() && (patt0$temp = stack.method_7909()) instanceof class_1831 && (toolItem = (class_1831)patt0$temp).method_8022() == ModToolMaterials.BONE) {
                if (stack.method_7919() + 30 >= stack.method_7936()) {
                    return class_1271.method_22431((Object)stack);
                }
                if (!world.method_8608()) {
                    stack.method_7956(30, (class_1309)player, e -> e.method_20236(hand));
                    BoneToolUseEvent.activateBoneShield(player, (class_3218)world);
                }
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
    }

    private static void activateBoneShield(class_1657 player, class_3218 world) {
        BoneToolUseEvent.clearActiveBonesForPlayer(player);
        player.method_6092(new class_1293(class_1294.field_5898, 200, 2, false, true));
        activeShields.put(player.method_5667(), world.method_8510() + 200L);
        ArrayList<class_1297> bones = new ArrayList<class_1297>();
        playerBones.put(player.method_5667(), bones);
        for (int i = 0; i < 3; ++i) {
            class_1297 armorStand = class_1299.field_6131.method_5883((class_1937)world);
            if (armorStand == null) continue;
            armorStand.method_33574(player.method_19538());
            armorStand.method_5875(true);
            armorStand.method_5684(true);
            armorStand.method_5648(true);
            armorStand.method_5803(true);
            armorStand.method_5780("bone_shield");
            world.method_8649(armorStand);
            bones.add(armorStand);
        }
        world.method_8396(null, player.method_24515(), class_3417.field_14588, class_3419.field_15248, 1.0f, 0.8f);
    }

    private static void clearActiveBonesForPlayer(class_1657 player) {
        List<class_1297> bones = playerBones.get(player.method_5667());
        if (bones != null) {
            for (class_1297 bone : bones) {
                if (!bone.method_5805()) continue;
                bone.method_31472();
            }
            playerBones.remove(player.method_5667());
        }
        activeShields.remove(player.method_5667());
    }

    public static void updateBoneShields(class_3218 world) {
        long currentTime = world.method_8510();
        for (Map.Entry<UUID, Long> entry : new ArrayList<Map.Entry<UUID, Long>>(activeShields.entrySet())) {
            List<class_1297> bones;
            class_1657 player;
            UUID playerId = entry.getKey();
            long endTime = entry.getValue();
            if (currentTime >= endTime) {
                player = world.method_18470(playerId);
                if (player != null) {
                    BoneToolUseEvent.clearActiveBonesForPlayer(player);
                    continue;
                }
                activeShields.remove(playerId);
                playerBones.remove(playerId);
                continue;
            }
            player = world.method_18470(playerId);
            if (player == null || (bones = playerBones.get(playerId)) == null || bones.isEmpty()) continue;
            for (int i = 0; i < bones.size(); ++i) {
                class_1297 bone = bones.get(i);
                if (!bone.method_5805()) continue;
                double angle = (double)(currentTime % 360L) * Math.PI / 180.0 + (double)(i * 120) * Math.PI / 180.0;
                double radius = 1.5;
                double x = player.method_23317() + radius * Math.cos(angle);
                double y = player.method_23318() + 1.0;
                double z = player.method_23321() + radius * Math.sin(angle);
                bone.method_5814(x, y, z);
                world.method_14199((class_2394)class_2398.field_22247, bone.method_23317(), bone.method_23318(), bone.method_23321(), 2, 0.1, 0.1, 0.1, 0.01);
                class_238 area = bone.method_5829().method_1014(0.5);
                for (class_1297 entity : world.method_8335((class_1297)player, area)) {
                    if (!(entity instanceof class_1309) || entity.method_5752().contains("bone_shield")) continue;
                    entity.method_5643(world.method_48963().method_48831(), 2.0f);
                }
                for (class_1297 projectile : world.method_8335(bone, bone.method_5829())) {
                    if (!(projectile instanceof class_1676)) continue;
                    class_243 velocity = projectile.method_18798();
                    projectile.method_18800(-velocity.field_1352, -velocity.field_1351, -velocity.field_1350);
                }
            }
        }
    }
}

