/*
 * Decompiled with CFR 0.152.
 */
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import java.util.ArrayList;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class StringToolUseEvent {
    private static final int DURABILITY_COST = 15;
    private static final int RANGE = 15;
    private static final float DAMAGE = 6.0f;
    private static final int BLEED_DURATION = 200;
    private static final double ATTACK_WIDTH = 2.0;

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1831 toolItem;
            class_1792 patt0$temp;
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430((Object)stack);
            }
            if (player.method_5715() && (patt0$temp = stack.method_7909()) instanceof class_1831 && (toolItem = (class_1831)patt0$temp).method_8022() == ModToolMaterials.STRING) {
                if (stack.method_7919() + 15 >= stack.method_7936()) {
                    return class_1271.method_22431((Object)stack);
                }
                if (!world.method_8608()) {
                    stack.method_7956(15, (class_1309)player, e -> e.method_20236(hand));
                    StringToolUseEvent.performStringCut(player, (class_3218)world);
                }
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
    }

    private static void performStringCut(class_1657 player, class_3218 world) {
        class_243 lookVec = player.method_5828(1.0f);
        class_243 startPos = player.method_5836(1.0f);
        class_243 endPos = startPos.method_1019(lookVec.method_1021(15.0));
        world.method_8396(null, player.method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, 1.8f);
        StringToolUseEvent.createCuttingEffect(world, startPos, endPos);
        StringToolUseEvent.damageEntitiesInPath(world, player, startPos, endPos);
    }

    private static void createCuttingEffect(class_3218 world, class_243 start, class_243 end) {
        int points = 30;
        ArrayList<class_243> linePoints = new ArrayList<class_243>();
        for (int i = 0; i <= points; ++i) {
            double progress = (double)i / (double)points;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * progress;
            double y = start.field_1351 + (end.field_1351 - start.field_1351) * progress;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * progress;
            linePoints.add(new class_243(x, y, z));
        }
        for (class_243 point : linePoints) {
            world.method_14199((class_2394)class_2398.field_11207, point.field_1352, point.field_1351, point.field_1350, 3, 0.2, 0.2, 0.2, 0.01);
            if (!(world.field_9229.method_43057() < 0.4f)) continue;
            double offsetX = (world.field_9229.method_43058() - 0.5) * 2.0;
            double offsetY = (world.field_9229.method_43058() - 0.5) * 0.5;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_29644, point.field_1352 + offsetX, point.field_1351 + offsetY, point.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
        }
        world.method_14199((class_2394)class_2398.field_11205, start.field_1352, start.field_1351, start.field_1350, 15, 0.2, 0.2, 0.2, 0.1);
        world.method_14199((class_2394)class_2398.field_11205, end.field_1352, end.field_1351, end.field_1350, 15, 0.2, 0.2, 0.2, 0.1);
    }

    private static void damageEntitiesInPath(class_3218 world, class_1657 player, class_243 start, class_243 end) {
        double minX = Math.min(start.field_1352, end.field_1352) - 2.0;
        double minY = Math.min(start.field_1351, end.field_1351) - 1.0;
        double minZ = Math.min(start.field_1350, end.field_1350) - 2.0;
        double maxX = Math.max(start.field_1352, end.field_1352) + 2.0;
        double maxY = Math.max(start.field_1351, end.field_1351) + 1.0;
        double maxZ = Math.max(start.field_1350, end.field_1350) + 2.0;
        class_238 pathBox = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        class_1282 source = world.method_48963().method_48802(player);
        for (class_1297 entity : world.method_8335((class_1297)player, pathBox)) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity;
            double distance = StringToolUseEvent.distanceToLine(start, end, entity.method_19538());
            if (!(distance < 2.0)) continue;
            float finalDamage = 6.0f * (float)(1.0 - distance / 2.0);
            living.method_5643(source, finalDamage);
            living.method_6092(new class_1293(class_1294.field_5920, 200, 0));
            world.method_14199((class_2394)class_2398.field_11209, entity.method_23317(), entity.method_23318() + (double)(entity.method_17682() / 2.0f), entity.method_23321(), 10, 0.3, 0.3, 0.3, 0.1);
        }
    }

    private static double distanceToLine(class_243 lineStart, class_243 lineEnd, class_243 point) {
        class_243 lineVec = lineEnd.method_1020(lineStart);
        class_243 pointVec = point.method_1020(lineStart);
        double lineLength = lineVec.method_1033();
        double dotProduct = pointVec.method_1026(lineVec) / lineLength;
        double t = Math.max(0.0, Math.min(1.0, dotProduct / lineLength));
        class_243 projection = lineStart.method_1019(lineVec.method_1021(t));
        return projection.method_1022(point);
    }
}

