/*
 * Decompiled with CFR 0.152.
 */
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModArmorMaterials;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ArmorEffectHandler {
    private static final Map<ModArmorMaterials, List<class_1293>> ARMOR_EFFECTS_MAP = new EnumMap<ModArmorMaterials, List<class_1293>>(ModArmorMaterials.class);
    private static final Random RANDOM;

    public static void register() {
        ArmorEffectHandler.initArmorEffects();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (!ArmorEffectHandler.checkConfig()) {
                return true;
            }
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                ArmorEffectHandler.applyReflectiveDamage(entity, attacker);
            }
            return true;
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (!ArmorEffectHandler.checkConfig()) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            for (class_1657 player : world.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                ArmorEffectHandler.applyContinuousEffects(player);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!ArmorEffectHandler.checkConfig()) {
                return;
            }
            ArmorEffectHandler.applyContinuousEffects((class_1657)player);
        });
    }

    private static boolean checkConfig() {
        return ModConfigManager.CONFIG.toolEffects.enableToolSkills && ModConfigManager.CONFIG.armorEffects.enableArmorEffects;
    }

    private static void initArmorEffects() {
    }

    private static void applyReflectiveDamage(class_1309 wearer, class_1309 attacker) {
        class_1792 class_17922;
        float totalEffectPower = 0.0f;
        ModArmorMaterials primaryMaterial = null;
        for (class_1799 armor : wearer.method_5661()) {
            class_1738 armorItem;
            class_17922 = armor.method_7909();
            if (!(class_17922 instanceof class_1738) || !((class_17922 = (armorItem = (class_1738)class_17922).method_7686()) instanceof ModArmorMaterials)) continue;
            ModArmorMaterials mat = (ModArmorMaterials)class_17922;
            totalEffectPower += mat.getEffectPower();
            primaryMaterial = mat;
        }
        if (totalEffectPower > 0.0f) {
            float reflectChance = ModConfigManager.CONFIG.armorEffects.armorReflectChance / 100.0f;
            if (wearer.method_6051().method_43057() < reflectChance) {
                float reflectDamage = ModConfigManager.CONFIG.armorEffects.armorReflectDamage;
                attacker.method_5643(wearer.method_48923().method_48818((class_1297)wearer), reflectDamage);
                wearer.method_6092(new class_1293(class_1294.field_5912, 40, 0, true, false));
            }
            if (primaryMaterial == ModArmorMaterials.LAPIS) {
                float xpStealChance = 0.3f;
                if (wearer.method_6051().method_43057() < xpStealChance) {
                    int stolenXp = 1 + RANDOM.nextInt(3);
                    if (attacker instanceof class_1657) {
                        ((class_1657)attacker).method_7255(-stolenXp);
                    }
                    if (wearer instanceof class_1657) {
                        ((class_1657)wearer).method_7255(stolenXp);
                        class_17922 = wearer.method_37908();
                        if (class_17922 instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)class_17922;
                            serverWorld.method_14199((class_2394)class_2398.field_11215, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
                        }
                    }
                }
            }
        }
    }

    private static void applyContinuousEffects(class_1657 player) {
        for (Map.Entry<ModArmorMaterials, List<class_1293>> entry : ARMOR_EFFECTS_MAP.entrySet()) {
            ModArmorMaterials material = entry.getKey();
            List<class_1293> effects = entry.getValue();
            if (!ArmorEffectHandler.hasFullSet(player, material)) continue;
            for (class_1293 effect : effects) {
                ArmorEffectHandler.applyEffectWithRefresh(player, effect);
            }
        }
    }

    private static void applyEffectWithRefresh(class_1657 player, class_1293 effect) {
        class_1293 current = player.method_6112(effect.method_5579());
        if (current == null || current.method_5584() <= 10) {
            player.method_6092(new class_1293(effect.method_5579(), 200, effect.method_5578(), false, false, true));
        }
    }

    private static boolean hasFullSet(class_1657 player, ModArmorMaterials material) {
        return ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6169), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6174), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6172), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6166), material);
    }

    private static boolean isArmorOfMaterial(class_1799 stack, ModArmorMaterials material) {
        class_1738 armorItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7686() == material;
    }

    static {
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.EMERALD, List.of(new class_1293(class_1294.field_5926, 100, 1, false, false, true)));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.LAPIS, List.of(new class_1293(class_1294.field_5907, 100, 0, false, false, true)));
        RANDOM = new Random();
    }
}

