/*
 * Decompiled with CFR 0.152.
 */
package com.stools.datagen;

import com.stools.item.ModItems;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class ModEnUsLangProvider
extends FabricLanguageProvider {
    public ModEnUsLangProvider(FabricDataOutput dataOutput) {
        super(dataOutput, "en_us");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(ModItems.MACE, "Mace");
        translationBuilder.add("itemGroup.strangetools.tools_group", "Strange Tools");
        translationBuilder.add("itemGroup.strangetools.armor_group", "Strange Armor");
        this.generateItemTranslations(translationBuilder, ModItems.TOOL_IDS);
        this.generateItemTranslations(translationBuilder, ModItems.ARMOR_IDS);
    }

    private void generateItemTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, List<String> itemIds) {
        for (String itemId : itemIds) {
            String[] parts = itemId.split("_");
            if (parts.length < 2) continue;
            StringBuilder translation = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    translation.append(" ");
                }
                translation.append(this.capitalize(parts[i]));
            }
            translationBuilder.add("item.strangetools." + itemId, translation.toString());
        }
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

