/*
 * Decompiled with CFR 0.152.
 */
package com.stools.config;

import com.stools.Strangetools;
import com.stools.config.BaseModConfig;
import com.stools.config.ModConfigManager;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.class_1269;

@Config(name="strangetools")
public class ClothModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="general")
    public int configVersion = 1;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.TransitiveObject
    public GeneralSettings general = new GeneralSettings();
    @ConfigEntry.Category(value="tool_effects")
    @ConfigEntry.Gui.TransitiveObject
    public ToolEffectsSettings toolEffects = new ToolEffectsSettings();
    @ConfigEntry.Category(value="armor_effects")
    @ConfigEntry.Gui.TransitiveObject
    public ArmorEffectsSettings armorEffects = new ArmorEffectsSettings();
    @ConfigEntry.Category(value="glowstone_effects")
    @ConfigEntry.Gui.TransitiveObject
    public GlowstoneEffectsSettings glowstoneEffects = new GlowstoneEffectsSettings();
    @ConfigEntry.Category(value="glass_effects")
    @ConfigEntry.Gui.TransitiveObject
    public GlassEffectsSettings glassEffects = new GlassEffectsSettings();
    @ConfigEntry.Category(value="glass_tool")
    @ConfigEntry.Gui.TransitiveObject
    public GlassToolSettings glassTool = new GlassToolSettings();

    public void copyTo(BaseModConfig baseConfig) {
        baseConfig.configVersion = this.configVersion;
        baseConfig.general.enableDebugMode = this.general.enableDebugMode;
        baseConfig.general.enableAllEffects = this.general.enableAllEffects;
        baseConfig.toolEffects.enableToolEffects = this.toolEffects.enableToolEffects;
        baseConfig.toolEffects.enableToolSkills = this.toolEffects.enableToolSkills;
        baseConfig.toolEffects.emeraldDropChance = this.toolEffects.emeraldDropChance;
        baseConfig.toolEffects.copperIgniteChance = this.toolEffects.copperIgniteChance;
        baseConfig.toolEffects.quartzExtraDamage = this.toolEffects.quartzExtraDamage;
        baseConfig.toolEffects.rottenFleshHungerChance = this.toolEffects.rottenFleshHungerChance;
        baseConfig.toolEffects.endStoneDamageBonus = this.toolEffects.endStoneDamageBonus;
        baseConfig.toolEffects.sweetBerriesPoisonChance = this.toolEffects.sweetBerriesPoisonChance;
        baseConfig.toolEffects.poisonousPotatoPoisonChance = this.toolEffects.poisonousPotatoPoisonChance;
        baseConfig.toolEffects.poisonousPotatoEatPoisonChance = this.toolEffects.poisonousPotatoEatPoisonChance;
        baseConfig.armorEffects.enableArmorEffects = this.armorEffects.enableArmorEffects;
        baseConfig.armorEffects.armorReflectChance = this.armorEffects.armorReflectChance;
        baseConfig.armorEffects.armorReflectDamage = this.armorEffects.armorReflectDamage;
        baseConfig.armorEffects.copperPushChance = this.armorEffects.copperPushChance;
        baseConfig.armorEffects.copperCleanseChance = this.armorEffects.copperCleanseChance;
        baseConfig.glowstoneEffects.enableEffects = this.glowstoneEffects.enableEffects;
        baseConfig.glowstoneEffects.damageAmount = this.glowstoneEffects.damageAmount;
        baseConfig.glowstoneEffects.range = this.glowstoneEffects.range;
        baseConfig.glowstoneEffects.glowingDuration = this.glowstoneEffects.glowingDuration;
        baseConfig.glowstoneEffects.speedDuration = this.glowstoneEffects.speedDuration;
        baseConfig.glowstoneEffects.durabilityCost = this.glowstoneEffects.durabilityCost;
        baseConfig.glassEffects.enableEffects = this.glassEffects.enableEffects;
        baseConfig.glassEffects.shatterReflectChance = this.glassEffects.shatterReflectChance;
        baseConfig.glassEffects.shatterReflectDamage = this.glassEffects.shatterReflectDamage;
        baseConfig.glassEffects.shatterDurabilityCost = this.glassEffects.shatterDurabilityCost;
        baseConfig.glassEffects.dashDurabilityCost = this.glassEffects.dashDurabilityCost;
        baseConfig.glassEffects.dashDuration = this.glassEffects.dashDuration;
        baseConfig.glassEffects.cutDoubleDropChance = this.glassEffects.cutDoubleDropChance;
        baseConfig.glassTool.enableDoubleDrop = this.glassTool.enableDoubleDrop;
        baseConfig.glassTool.doubleDropChance = this.glassTool.doubleDropChance;
        baseConfig.glassTool.doubleDropDurabilityCost = this.glassTool.doubleDropDurabilityCost;
    }

    public static void initialize() {
        if (ClothModConfig.isClothConfigLoaded()) {
            AutoConfig.register(ClothModConfig.class, JanksonConfigSerializer::new);
            AutoConfig.getConfigHolder(ClothModConfig.class).registerSaveListener((manager, data) -> {
                data.copyTo(ModConfigManager.CONFIG);
                return class_1269.field_5812;
            });
            Strangetools.LOGGER.info("Cloth Config initialized");
        }
    }

    private static boolean isClothConfigLoaded() {
        try {
            Class.forName("me.shedaniel.autoconfig.AutoConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static class GeneralSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableDebugMode = false;
        @ConfigEntry.Gui.Tooltip
        public boolean enableAllEffects = true;
    }

    public static class ToolEffectsSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableToolEffects = true;
        @ConfigEntry.Gui.Tooltip
        public boolean enableToolSkills = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float emeraldDropChance = 1.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float copperIgniteChance = 30.0f;
        @ConfigEntry.Gui.Tooltip
        public float quartzExtraDamage = 2.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float rottenFleshHungerChance = 40.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float endStoneDamageBonus = 25.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float sweetBerriesPoisonChance = 5.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float poisonousPotatoPoisonChance = 15.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float poisonousPotatoEatPoisonChance = 60.0f;
    }

    public static class ArmorEffectsSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableArmorEffects = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float armorReflectChance = 30.0f;
        @ConfigEntry.Gui.Tooltip
        public float armorReflectDamage = 2.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float copperPushChance = 5.0f;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float copperCleanseChance = 15.0f;
    }

    public static class GlowstoneEffectsSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableEffects = true;
        @ConfigEntry.Gui.Tooltip
        public float damageAmount = 2.0f;
        @ConfigEntry.Gui.Tooltip
        public float range = 8.0f;
        @ConfigEntry.Gui.Tooltip
        public int glowingDuration = 10;
        @ConfigEntry.Gui.Tooltip
        public int speedDuration = 5;
        @ConfigEntry.Gui.Tooltip
        public int durabilityCost = 10;
    }

    public static class GlassEffectsSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableEffects = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float shatterReflectChance = 30.0f;
        @ConfigEntry.Gui.Tooltip
        public float shatterReflectDamage = 2.0f;
        @ConfigEntry.Gui.Tooltip
        public int shatterDurabilityCost = 20;
        @ConfigEntry.Gui.Tooltip
        public int dashDurabilityCost = 30;
        @ConfigEntry.Gui.Tooltip
        public int dashDuration = 5;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float cutDoubleDropChance = 10.0f;
    }

    public static class GlassToolSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableDoubleDrop = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public float doubleDropChance = 10.0f;
        @ConfigEntry.Gui.Tooltip
        public int doubleDropDurabilityCost = 2;
    }
}

