/*
 * Decompiled with CFR 0.152.
 */
package com.stools.mixin;

import com.stools.item.materials.ModToolMaterials;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2248.class})
public class BlockMixin {
    private static final ModToolMaterials[] FLAME_MATERIALS = new ModToolMaterials[]{ModToolMaterials.BLAZE_POWDER, ModToolMaterials.NETHERRACK, ModToolMaterials.COAL};

    @Inject(method={"afterBreak"}, at={@At(value="HEAD")}, cancellable=true)
    private void afterBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1799 stack, CallbackInfo ci) {
        if (world.method_8608()) {
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1831)) {
            return;
        }
        class_1831 tool = (class_1831)class_17922;
        class_1832 class_18322 = tool.method_8022();
        if (!(class_18322 instanceof ModToolMaterials)) {
            return;
        }
        ModToolMaterials material = (ModToolMaterials)class_18322;
        if (!this.isFlameTool(material) || !(tool instanceof class_1810)) {
            return;
        }
        if (world.field_9229.method_43057() < 0.5f) {
            int fortuneLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack);
            BlockMixin.handleSmeltingDrop((class_3218)world, pos, (class_2248)this, player, fortuneLevel, ci);
        }
    }

    @Unique
    private boolean isFlameTool(ModToolMaterials material) {
        for (ModToolMaterials flameMat : FLAME_MATERIALS) {
            if (material != flameMat) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static void handleSmeltingDrop(class_3218 world, class_2338 pos, class_2248 block, class_1657 player, int fortuneLevel, CallbackInfo ci) {
        class_1799 rawDrop = new class_1799((class_1935)block.method_8389());
        if (rawDrop.method_7960()) {
            return;
        }
        Optional recipe = world.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{rawDrop}), (class_1937)world);
        if (recipe.isPresent()) {
            class_1799 smelted = ((class_3861)recipe.get()).method_8110(world.method_30349()).method_7972();
            int dropCount = BlockMixin.calculateDropCount(fortuneLevel, world);
            smelted.method_7939(dropCount);
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)smelted);
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            world.method_33596((class_1297)player, class_5712.field_28165, pos);
            ci.cancel();
        }
    }

    @Unique
    private static int calculateDropCount(int fortuneLevel, class_3218 world) {
        int dropCount = 1;
        if (fortuneLevel > 0 && world.field_9229.method_43048(fortuneLevel + 2) - 1 > 0) {
            dropCount = world.field_9229.method_43048(fortuneLevel + 1) + 1;
        }
        return dropCount;
    }
}

