package com.stools.entity;

import com.stools.item.ModItems;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3857;
import net.minecraft.class_3966;

public class VoidPearlEntity extends class_3857 {

    public VoidPearlEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public VoidPearlEntity(class_1937 world, class_1309 owner) {
        super(ModEntities.VOID_PEARL, owner, world);
    }

    @Override
    protected class_1792 method_16942() {
        return ModItems.VOID_PEARL;
    }

    @Override
    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        class_1937 world = method_37908();

        if (world instanceof class_3218 serverWorld) {
            serverWorld.method_14199(
                    class_2398.field_11214,
                    this.method_23317(),
                    this.method_23318(),
                    this.method_23321(),
                    30, // 增加粒子数量
                    0.0, 0.0, 0.0,
                    0.2 // 提高速度
            );
        }

        if (!world.field_9236 && !this.method_31481()) {
            if (this.method_24921() instanceof class_1309 owner) {
                // 添加传送音效
                world.method_43128(
                        null,
                        owner.method_23317(), owner.method_23318(), owner.method_23321(),
                        class_3417.field_14879,
                        class_3419.field_15248,
                        1.0f,
                        0.8f
                );

                owner.method_5859(this.method_23317(), this.method_23318(), this.method_23321());
                owner.field_6017 = 0.0F;

                if (world instanceof class_3218 serverWorld) {
                    serverWorld.method_14199(
                            class_2398.field_23190,
                            owner.method_23317(), owner.method_23318() + 1, owner.method_23321(),
                            80, // 增加粒子数量
                            0.7, 0.7, 0.7, // 扩大范围
                            0.15 // 提高速度
                    );
                }
            }
            this.method_31472();
        }
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        // 覆盖此方法以防止对碰撞实体造成伤害
        // 原版末影珍珠会在这里造成伤害
    }

    @Override
    public void method_5773() {
        super.method_5773();

        // 检查拥有者是否存活
        class_1297 owner = this.method_24921();
        if (owner instanceof class_1309 && !((class_1309) owner).method_5805()) {
            this.method_31472(); // 玩家死亡时丢弃实体
            return;
        }

        // 添加轨迹粒子效果
        if (!this.method_37908().method_8608() && this.method_37908() instanceof class_3218 serverWorld) {
            serverWorld.method_14199(
                    class_2398.field_23190,
                    this.method_23317(),
                    this.method_23318(),
                    this.method_23321(),
                    1,
                    0.0, 0.0, 0.0,
                    0.01
            );
        }
    }
}