package com.stools.event;

import com.stools.config.ModConfigManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import com.stools.item.materials.ModArmorMaterials;
import org.joml.Vector3f;

import java.util.*;

public class ArmorEffectHandler {
    private static final Map<ModArmorMaterials, List<class_1293>> ARMOR_EFFECTS_MAP =
            new EnumMap<>(ModArmorMaterials.class);

    static {
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.EMERALD, List.of(
                new class_1293(class_1294.field_5926, 100, 1, false, false, true)
        ));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.LAPIS, List.of(
                new class_1293(class_1294.field_5907, 100, 0, false, false, true)
        ));
    }

    private static final Random RANDOM = new Random();

    public static void register() {
        initArmorEffects();

        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            // 修复检查逻辑
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return true;
            }

            if (source.method_5529() instanceof class_1309 attacker) {
                applyReflectiveDamage(entity, attacker);
            }
            return true;
        });

        ServerTickEvents.START_WORLD_TICK.register(world -> {
            // 修复检查逻辑
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }

            if (!(world instanceof class_3218)) return;

            for (class_1657 player : world.method_18456()) {
                if (player instanceof class_3222) {
                    applyContinuousEffects(player);
                }
            }
        });

        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            // 修复检查逻辑
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }

            applyContinuousEffects(player);
        });
    }

    private static void initArmorEffects() {
        // 可扩展添加更多盔甲效果
    }

    private static void applyReflectiveDamage(class_1309 wearer, class_1309 attacker) {
        float totalEffectPower = 0;
        ModArmorMaterials primaryMaterial = null;

        for (class_1799 armor : wearer.method_5661()) {
            if (armor.method_7909() instanceof class_1738 armorItem &&
                    armorItem.method_7686() instanceof ModArmorMaterials mat) {
                totalEffectPower += mat.getEffectPower();
                // 确保只设置一次主要材料
                if (primaryMaterial == null) {
                    primaryMaterial = mat;
                }
            }
        }

        // 确保primaryMaterial不为null
        if (totalEffectPower > 0 && primaryMaterial != null) {
            // 绿宝石盔甲专属效果：反弹伤害
            if (primaryMaterial == ModArmorMaterials.EMERALD) {
                float reflectChance = ModConfigManager.CONFIG.armorEffects.armorReflectChance / 100f;
                if (wearer.method_6051().method_43057() < reflectChance) {
                    float reflectDamage = ModConfigManager.CONFIG.armorEffects.armorReflectDamage;
                    attacker.method_5643(wearer.method_48923().method_48818(wearer), reflectDamage);
                    wearer.method_6092(new class_1293(
                            class_1294.field_5912, 40, 0, true, false));
                }
            }

            // 青金石盔甲专属效果：经验窃取
            if (primaryMaterial == ModArmorMaterials.LAPIS) {
                float xpStealChance = 0.3f;
                if (wearer.method_6051().method_43057() < xpStealChance) {
                    int stolenXp = 1 + RANDOM.nextInt(3);

                    if (attacker instanceof class_1657) {
                        ((class_1657) attacker).method_7255(-stolenXp);
                    }
                    if (wearer instanceof class_1657) {
                        ((class_1657) wearer).method_7255(stolenXp);

                        if (wearer.method_37908() instanceof class_3218 serverWorld) {
                            serverWorld.method_14199(class_2398.field_11215,
                                    wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(),
                                    10, 0.5, 0.5, 0.5, 0.1);
                        }
                    }
                }
            }

            // 铜盔甲专属效果
            if (primaryMaterial == ModArmorMaterials.COPPER) {
                // 效果1: 简易导电 - 雷暴天气小概率击退敌人
                if (wearer.method_37908().method_8546()) {
                    float lightningChance = ModConfigManager.CONFIG.armorEffects.copperPushChance / 100f;
                    if (RANDOM.nextFloat() < lightningChance) {
                        attacker.method_6005(0.5f,
                                wearer.method_23317() - attacker.method_23317(),
                                wearer.method_23321() - attacker.method_23321());
                        wearer.method_37908().method_8396(null, attacker.method_24515(),
                                class_3417.field_14865,
                                class_3419.field_15248, 0.5f, 1.5f);
                    }
                }

                // 效果2: 基础净化 - 概率清除一个负面效果
                float cleanseChance = ModConfigManager.CONFIG.armorEffects.copperCleanseChance / 100f;
                if (RANDOM.nextFloat() < cleanseChance) {
                    Optional<class_1291> effectToRemove = wearer.method_6088().keySet().stream()
                            .filter(effect -> !effect.method_5573())
                            .findAny();
                    effectToRemove.ifPresent(effect -> {
                        wearer.method_6016(effect);
                        if (wearer.method_37908() instanceof class_3218 serverWorld) {
                            serverWorld.method_14199(class_2398.field_11211,
                                    wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(),
                                    5, 0.3, 0.3, 0.3, 0.1);
                        }
                    });
                }
            }

            // 红石盔甲专属效果
            if (primaryMaterial == ModArmorMaterials.REDSTONE) {
                // 效果1: 微弱红石脉冲 - 小概率给予攻击者短暂缓慢
                float slowChance = 0.12f;
                if (RANDOM.nextFloat() < slowChance) {
                    attacker.method_6092(new class_1293(
                            class_1294.field_5909,
                            40, 0, false, false, true
                    ));

                    // 修复粒子生成 - 使用DustParticleEffect
                    if (wearer.method_37908() instanceof class_3218 serverWorld) {
                        // 创建红色粒子效果 (红石颜色)
                        class_2390 dustEffect = new class_2390(
                                new Vector3f(1.0f, 0.0f, 0.0f), // RGB 红色
                                1.0f // 大小
                        );

                        serverWorld.method_14199(
                                dustEffect,
                                attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(),
                                5, // 粒子数量
                                0.3, 0.3, 0.3, // 偏移量
                                0.1 // 速度
                        );
                    }
                }

                // 效果2: 能量反馈 - 被攻击时回复少量耐久
                float repairChance = 0.15f;
                if (RANDOM.nextFloat() < repairChance) {
                    for (class_1799 armor : wearer.method_5661()) {
                        if (armor.method_7986()) {
                            armor.method_7974(armor.method_7919() - 1);
                        }
                    }
                    wearer.method_37908().method_8396(null, wearer.method_24515(),
                            class_3417.field_26980,
                            class_3419.field_15248, 0.6f, 1.8f);
                }
            }
        }
        if (primaryMaterial == ModArmorMaterials.COAL) {
            //被攻击时概率点燃攻击者
            float igniteChance = 0.15f + (totalEffectPower * 0.05f); // 基础15% + 每件盔甲增加5%
            if (RANDOM.nextFloat() < igniteChance) {
                int fireTime = 1 + RANDOM.nextInt(3); // 1-3秒燃烧时间
                attacker.method_5639(fireTime * 20); // 转换为游戏刻

                // 粒子效果
                if (wearer.method_37908() instanceof class_3218 serverWorld) {
                    serverWorld.method_14199(class_2398.field_11240,
                            attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(),
                            10, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }
    }
    private static void applyContinuousEffects(class_1657 player) {
        for (Map.Entry<ModArmorMaterials, List<class_1293>> entry : ARMOR_EFFECTS_MAP.entrySet()) {
            ModArmorMaterials material = entry.getKey();
            List<class_1293> effects = entry.getValue();

            if (hasFullSet(player, material)) {
                for (class_1293 effect : effects) {
                    applyEffectWithRefresh(player, effect);
                }
            }
        }
    }

    private static void applyEffectWithRefresh(class_1657 player, class_1293 effect) {
        class_1293 current = player.method_6112(effect.method_5579());

        if (current == null || current.method_5584() <= 10) {
            player.method_6092(new class_1293(
                    effect.method_5579(),
                    20,
                    effect.method_5578(),
                    false, false, true
            ));
        }
    }

    private static boolean hasFullSet(class_1657 player, ModArmorMaterials material) {
        return isArmorOfMaterial(player.method_6118(class_1304.field_6169), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6174), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6172), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6166), material);
    }

    private static boolean isArmorOfMaterial(class_1799 stack, ModArmorMaterials material) {
        return stack.method_7909() instanceof class_1738 armorItem &&
                armorItem.method_7686() == material;
    }
}