package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import com.stools.sound.ModSoundEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_8109;

public class BedrockToolUseEvent {

    private static final int DURABILITY_COST = 100;

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            // 先获取物品栈，再进行开关判断
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }

            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.BEDROCK) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));

                        activateBedrockAbility(player, world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void activateBedrockAbility(class_1657 player, class_1937 world) {
        player.method_6092(new class_1293(
                class_1294.field_5907,
                200,
                4,
                false,
                true
        ));

        class_2338 pos = player.method_24515();
        class_238 area = new class_238(pos.method_10069(-5, -2, -5), pos.method_10069(5, 3, 5));

        class_8109 damageSources = world.method_48963();

        for (class_1297 entity : world.method_8333(player, area, e -> e instanceof class_1309)) {
            entity.method_5643(damageSources.method_48802(player), 5.0f);

            class_243 awayDirection = entity.method_19538().method_1020(player.method_19538()).method_1029();
            entity.method_5762(awayDirection.field_1352 * 2.0, 0.5, awayDirection.field_1350 * 2.0);
        }

        world.method_8396(null, pos,
                ModSoundEvents.MACE_SMASH_AIR,
                class_3419.field_15248, 1.0f, 0.8f);

        if (world instanceof class_3218 serverWorld) {
            serverWorld.method_14199(
                    new class_2388(class_2398.field_11217, class_2246.field_9987.method_9564()),
                    player.method_23317(),
                    player.method_23318() + 1.0,
                    player.method_23321(),
                    50,
                    3.0,
                    2.0,
                    3.0,
                    0.1
            );
        }
    }
}