package com.stools.event;

import com.stools.config.ModConfigManager;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import com.stools.item.materials.ModToolMaterials;

import java.util.Random;

public class ChorusFruitToolUseEvent {

    private static final Random random = new Random();
    private static final int DURABILITY_COST = 100;

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }

            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.CHORUS_FRUIT) {
                    int currentDamage = stack.method_7919();
                    int maxDamage = stack.method_7936();

                    // 检查耐久是否足够
                    if (currentDamage + DURABILITY_COST > maxDamage) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        // 消耗耐久
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));

                        // 恢复饥饿值和饱和度
                        player.method_7344().method_7585(4, 2.4f);

                        // 随机传送
                        teleportPlayer(player, (class_3218) world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void teleportPlayer(class_1657 player, class_3218 world) {
        // 尝试寻找安全位置
        class_2338 playerPos = player.method_24515();
        class_243 teleportPos = null;

        // 最多尝试10次寻找安全位置
        for (int i = 0; i < 10; i++) {
            // 在8格范围内随机选择位置
            double x = playerPos.method_10263() + (random.nextDouble() - 0.5) * 16;
            double z = playerPos.method_10260() + (random.nextDouble() - 0.5) * 16;
            double y = playerPos.method_10264() + random.nextInt(5) - 2;

            class_2338 testPos = class_2338.method_49637(x, y, z);

            // 检查位置是否安全
            if (isSafePosition(world, testPos)) {
                teleportPos = new class_243(x, y, z);
                break;
            }
        }

        // 如果没找到安全位置，使用玩家当前位置
        if (teleportPos == null) {
            teleportPos = player.method_19538();
        }

        // 传送玩家
        player.method_20620(teleportPos.field_1352, teleportPos.field_1351, teleportPos.field_1350);

        // 播放效果
        world.method_8396(null, player.method_24515(),
                class_3417.field_14879,
                class_3419.field_15248, 1.0f, 1.0f);

        world.method_14199(class_2398.field_11214,
                player.method_23317(), player.method_23318() + 1, player.method_23321(),
                30, 0.5, 0.5, 0.5, 0.1);
    }

    private static boolean isSafePosition(class_3218 world, class_2338 pos) {
        class_2338 downPos = pos.method_10074();

        // 检查目标位置下方是否有固体方块
        if (!world.method_8320(downPos).method_26212(world, downPos)) {
            return false;
        }

        // 检查目标位置是否可站立（非固体方块）
        if (world.method_8320(pos).method_26212(world, pos)) {
            return false;
        }

        // 检查目标位置上方是否有空间（非固体方块）
        if (world.method_8320(pos.method_10084()).method_26212(world, pos.method_10084())) {
            return false;
        }

        // 检查位置是否安全（非液体）
        return world.method_8316(pos).method_15769() &&
                world.method_8316(pos.method_10084()).method_15769();
    }
}