package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.ArrayList;
import java.util.List;

public class StringToolUseEvent {
    private static final int DURABILITY_COST = 15;
    private static final int RANGE = 15; // 增加切割范围
    private static final float DAMAGE = 6.0f; // 提高基础伤害
    private static final int BLEED_DURATION = 200; // 流血持续时间 (10秒)
    private static final double ATTACK_WIDTH = 2.0; // 增加切割宽度

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.STRING) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));
                        performStringCut(player, (class_3218) world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void performStringCut(class_1657 player, class_3218 world) {
        // 获取玩家视线方向
        class_243 lookVec = player.method_5828(1.0F);

        // 计算切割起点和终点
        class_243 startPos = player.method_5836(1.0F);
        class_243 endPos = startPos.method_1019(lookVec.method_1021(RANGE));

        // 播放音效
        world.method_8396(null, player.method_24515(),
                class_3417.field_14706,
                class_3419.field_15248, 1.0f, 1.8f);

        // 创建切割效果
        createCuttingEffect(world, startPos, endPos);

        // 检测并伤害路径上的实体
        damageEntitiesInPath(world, player, startPos, endPos);
    }

    private static void createCuttingEffect(class_3218 world, class_243 start, class_243 end) {
        // 计算切割路径上的粒子点
        int points = 30; // 粒子数量
        List<class_243> linePoints = new ArrayList<>();

        // 主路径
        for (int i = 0; i <= points; i++) {
            double progress = (double) i / points;
            double x = start.field_1352 + (end.field_1352 - start.field_1352) * progress;
            double y = start.field_1351 + (end.field_1351 - start.field_1351) * progress;
            double z = start.field_1350 + (end.field_1350 - start.field_1350) * progress;
            linePoints.add(new class_243(x, y, z));
        }

        // 生成切割粒子效果
        for (class_243 point : linePoints) {
            // 主切割线粒子
            world.method_14199(class_2398.field_11207,
                    point.field_1352, point.field_1351, point.field_1350,
                    3, 0.2, 0.2, 0.2, 0.01); // 粒子数量和范围

            // 添加"弦丝"粒子
            if (world.field_9229.method_43057() < 0.4f) {
                double offsetX = (world.field_9229.method_43058() - 0.5) * ATTACK_WIDTH;
                double offsetY = (world.field_9229.method_43058() - 0.5) * 0.5;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * ATTACK_WIDTH;

                world.method_14199(class_2398.field_29644,
                        point.field_1352 + offsetX, point.field_1351 + offsetY, point.field_1350 + offsetZ,
                        1, 0, 0, 0, 0.01);
            }
        }

        // 起点和终点的特效
        world.method_14199(class_2398.field_11205,
                start.field_1352, start.field_1351, start.field_1350,
                15, 0.2, 0.2, 0.2, 0.1);

        world.method_14199(class_2398.field_11205,
                end.field_1352, end.field_1351, end.field_1350,
                15, 0.2, 0.2, 0.2, 0.1);
    }

    private static void damageEntitiesInPath(class_3218 world, class_1657 player, class_243 start, class_243 end) {
        // 计算路径的包围盒
        double minX = Math.min(start.field_1352, end.field_1352) - ATTACK_WIDTH;
        double minY = Math.min(start.field_1351, end.field_1351) - ATTACK_WIDTH/2;
        double minZ = Math.min(start.field_1350, end.field_1350) - ATTACK_WIDTH;
        double maxX = Math.max(start.field_1352, end.field_1352) + ATTACK_WIDTH;
        double maxY = Math.max(start.field_1351, end.field_1351) + ATTACK_WIDTH/2;
        double maxZ = Math.max(start.field_1350, end.field_1350) + ATTACK_WIDTH;

        class_238 pathBox = new class_238(minX, minY, minZ, maxX, maxY, maxZ);

        // 获取伤害源
        class_1282 source = world.method_48963().method_48802(player);

        // 检测路径上的实体
        for (class_1297 entity : world.method_8335(player, pathBox)) {
            if (entity instanceof class_1309 living) {
                // 计算实体到切割线的距离
                double distance = distanceToLine(start, end, entity.method_19538());

                // 攻击范围2.0格
                if (distance < ATTACK_WIDTH) {
                    // 基础伤害 + 距离衰减
                    float finalDamage = DAMAGE * (float)(1.0 - (distance / ATTACK_WIDTH));

                    living.method_5643(source, finalDamage);

                    // 施加流血效果
                    living.method_6092(new class_1293(
                            class_1294.field_5920, BLEED_DURATION, 0));

                    // 伤害特效
                    world.method_14199(class_2398.field_11209,
                            entity.method_23317(), entity.method_23318() + entity.method_17682()/2, entity.method_23321(),
                            10, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
    }

    // 计算点到线段的距离
    private static double distanceToLine(class_243 lineStart, class_243 lineEnd, class_243 point) {
        class_243 lineVec = lineEnd.method_1020(lineStart);
        class_243 pointVec = point.method_1020(lineStart);

        double lineLength = lineVec.method_1033();
        double dotProduct = pointVec.method_1026(lineVec) / lineLength;

        // 计算投影点
        double t = Math.max(0, Math.min(1, dotProduct / lineLength));
        class_243 projection = lineStart.method_1019(lineVec.method_1021(t));

        return projection.method_1022(point);
    }
}