package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VoidToolUseEvent {
    private static final int DURABILITY_COST = 120;
    private static final Map<class_2338, Long> activeRifts = new HashMap<>();
    // 添加音效常量
    private static final float ACTIVATE_PITCH = 0.5f;
    private static final float DEACTIVATE_PITCH = 0.8f;

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills)
                return class_1271.method_22430(stack);

            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem &&
                    toolItem.method_8022() == ModToolMaterials.VOID) {

                if (stack.method_7919() + DURABILITY_COST >= stack.method_7936())
                    return class_1271.method_22431(stack);

                if (!world.method_8608()) {
                    class_243 lookVec = player.method_5828(1.0F);
                    class_243 targetPosVec = player.method_19538().method_1019(lookVec.method_1021(4));
                    class_2338 targetPos = class_2338.method_49638(targetPosVec);

                    // 添加技能释放音效
                    world.method_43128(
                            null,
                            player.method_23317(), player.method_23318(), player.method_23321(),
                            class_3417.field_14879,
                            class_3419.field_15248,
                            1.0f,
                            ACTIVATE_PITCH
                    );

                    createVoidRift((class_3218) world, targetPos);
                    stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));
                }
                return class_1271.method_22427(stack);
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void createVoidRift(class_3218 world, class_2338 pos) {
        activeRifts.put(pos, world.method_8510() + 100); // 5秒持续时间

        //音效
        world.method_43128(
                null,
                pos.method_10263(), pos.method_10264(), pos.method_10260(),
                class_3417.field_14981,
                class_3419.field_15248,
                1.5f,
                ACTIVATE_PITCH
        );

        //粒子效果
        world.method_14199(
                class_2398.field_23190,
                pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                150,  // 粒子数量
                2.0, 2.0, 2.0,  // 范围
                0.3   // 速度
        );

        // 额外粒子效果
        world.method_14199(
                class_2398.field_29644,
                pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                30,
                1.0, 1.0, 1.0,
                0.1
        );
    }

    public static void updateRifts(class_3218 world) {
        long currentTime = world.method_8510();
        Iterator<Map.Entry<class_2338, Long>> iterator = activeRifts.entrySet().iterator();

        while (iterator.hasNext()) {
            Map.Entry<class_2338, Long> entry = iterator.next();
            class_2338 pos = entry.getKey();

            if (currentTime > entry.getValue()) {
                // 裂隙结束时的效果
                world.method_14199(
                        class_2398.field_11236,
                        pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                        15, 0.5, 0.5, 0.5, 0.2
                );

                world.method_14199(
                        class_2398.field_11203,
                        pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                        50, 1.0, 1.0, 1.0, 0.1
                );

                // 添加结束音效
                world.method_43128(
                        null,
                        pos.method_10263(), pos.method_10264(), pos.method_10260(),
                        class_3417.field_14550,
                        class_3419.field_15248,
                        1.2f,
                        DEACTIVATE_PITCH
                );

                iterator.remove();
                continue;
            }

            class_238 area = new class_238(
                    pos.method_10263() - 3, pos.method_10264() - 1, pos.method_10260() - 3,
                    pos.method_10263() + 3, pos.method_10264() + 2, pos.method_10260() + 3
            );

            List<class_1309> entities = world.method_8390(
                    class_1309.class, area, e -> true
            );

            for (class_1309 entity : entities) {
                class_243 center = new class_243(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
                class_243 direction = center.method_1020(entity.method_19538()).method_1029();

                double distance = entity.method_19538().method_1022(center);
                double strength = 0.2 * (1.0 - Math.min(1.0, distance / 3.0));

                entity.method_5762(
                        direction.field_1352 * strength,
                        direction.field_1351 * strength * 0.5,
                        direction.field_1350 * strength
                );

                // 提高伤害值
                if (currentTime % 20 == 0) {
                    entity.method_5643(world.method_48963().method_48831(), 3.0f);

                    // 粒子效果
                    world.method_14199(
                            class_2398.field_11251,
                            entity.method_23317(), entity.method_23318() + 1, entity.method_23321(),
                            5, 0.3, 0.3, 0.3, 0.05
                    );
                }

                // 拉扯粒子效果
                if (currentTime % 3 == 0) {
                    world.method_14199(
                            class_2398.field_22247,
                            entity.method_23317(), entity.method_23318() + 0.5, entity.method_23321(),
                            2, 0.15, 0.15, 0.15, 0.02
                    );

                    // 添加从实体到中心的粒子流
                    class_243 particlePos = entity.method_19538().method_1031(
                            (center.field_1352 - entity.method_23317()) * 0.3,
                            (center.field_1351 - entity.method_23318()) * 0.3 + 0.5,
                            (center.field_1350 - entity.method_23321()) * 0.3
                    );

                    world.method_14199(
                            class_2398.field_11234,
                            particlePos.field_1352, particlePos.field_1351, particlePos.field_1350,
                            1, 0.0, 0.0, 0.0, 0.1
                    );
                }
            }

            // 中心粒子效果
            if (currentTime % 2 == 0) {
                world.method_14199(
                        class_2398.field_22246,
                        pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                        8, 0.4, 0.4, 0.4, 0.1
                );

                // 旋转粒子效果
                double angle = (currentTime % 100) * 0.0628; // 约6.28弧度/秒
                double radius = 1.0;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;

                world.method_14199(
                        class_2398.field_11249,
                        pos.method_10263() + 0.5 + xOffset, pos.method_10264() + 1.2, pos.method_10260() + 0.5 + zOffset,
                        2, 0.1, 0.1, 0.1, 0.05
                );
            }

            // 低频脉冲效果
            if (currentTime % 10 == 0) {
                world.method_14199(
                        class_2398.field_11207,
                        pos.method_10263() + 0.5, pos.method_10264() + 1.5, pos.method_10260() + 0.5,
                        10, 0.5, 0.5, 0.5, 0.2
                );

                // 脉冲音效
                world.method_43128(
                        null,
                        pos.method_10263(), pos.method_10264(), pos.method_10260(),
                        class_3417.field_15045,
                        class_3419.field_15248,
                        0.8f,
                        0.6f
                );
            }
        }
    }
}