package com.stools.event.glass;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class GlassToolSpecialSkillEvent {
    private static final int WATER_SKILL_COST = 10; // 提高消耗以平衡新技能
    private static final int LAVA_SKILL_COST = 20;
    private static final int WATER_SKILL_COOLDOWN = 40;
    private static final int LAVA_SKILL_COOLDOWN = 60;

    // 潮汐冲击参数
    private static final double TIDAL_WAVE_RANGE = 8.0; // 冲击波范围
    private static final double TIDAL_WAVE_WIDTH = 3.0; // 冲击波宽度
    private static final float TIDAL_DAMAGE = 3.0f; // 伤害值
    private static final int TIDAL_KNOCKBACK = 2; // 击退强度

    private static final int MAGMA_BURST_DAMAGE = 15; // 岩浆爆破消耗的耐久
    private static final int MAGMA_BURST_COOLDOWN = 60; // 3秒冷却
    private static final float EXPLOSION_POWER = 3.0f; // 爆炸强度

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            if (!(player.method_5715() && stack.method_7909() instanceof class_1831 tool &&
                    tool.method_8022() == ModToolMaterials.GLASS)) {
                return class_1271.method_22430(stack);
            }

            // 检查是否正对流体源（防止冲突）
            class_3965 fluidHit = raycast(world, player, class_3959.class_242.field_1345);
            if (fluidHit.method_17783() == class_239.class_240.field_1332) {
                if (world.method_8316(fluidHit.method_17777()).method_15767(class_3486.field_15517) ||
                        world.method_8316(fluidHit.method_17777()).method_15767(class_3486.field_15518)) {
                    return class_1271.method_22430(stack);
                }
            }

            class_2487 tag = stack.method_7948();
            String content = tag.method_10558("BottleContent");
            if (hand != class_1268.field_5808) return class_1271.method_22430(stack);

            // ===== 改进的水技能：潮汐冲击 =====
            if ("water".equals(content)) {
                if (stack.method_7919() + WATER_SKILL_COST >= stack.method_7936())
                    return class_1271.method_22431(stack);

                if (!world.method_8608()) {
                    // 播放技能启动音效
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(),
                            class_3417.field_14880, class_3419.field_15248,
                            1.0F, 0.8F);

                    // 创建潮汐冲击效果
                    createTidalWave(player, world);

                    // 移除玩家身上燃烧
                    player.method_5646();

                    // 扣耐久，清空
                    stack.method_7956(WATER_SKILL_COST, player, p -> p.method_20236(hand));
                    tag.method_10582("BottleContent", "empty");
                    stack.method_7980(tag);
                }

                // 添加冷却
                if (world instanceof net.minecraft.class_3218) {
                    player.method_7357().method_7906(stack.method_7909(), WATER_SKILL_COOLDOWN);
                }

                return class_1271.method_22427(stack);
            }

            if ("lava".equals(content)) {
                if (stack.method_7919() + MAGMA_BURST_DAMAGE >= stack.method_7936()) {
                    return class_1271.method_22431(stack);
                }

                if (!world.method_8608()) {
                    // 1. 在玩家位置创建爆炸效果
                    world.method_8537(
                            player,
                            player.method_23317(),
                            player.method_23318() + 1.0,
                            player.method_23321(),
                            EXPLOSION_POWER,
                            false,
                            class_1937.class_7867.field_40888
                    );

                    // 2. 对周围敌人造成伤害和点燃
                    class_238 area = new class_238(
                            player.method_24515().method_10069(-5, -2, -5),
                            player.method_24515().method_10069(5, 3, 5)
                    );

                    for (class_1309 entity : world.method_8390(
                            class_1309.class, area, e -> e != player)) {
                        // 造成火焰伤害
                        entity.method_5643(player.method_48923().method_48794(), 6.0f);

                        // 点燃实体
                        entity.method_5639(5);

                        // 添加击退效果
                        class_243 knockback = entity.method_19538().method_1020(player.method_19538()).method_1029();
                        entity.method_5762(knockback.field_1352 * 0.8, 0.4, knockback.field_1350 * 0.8);
                    }

                    // 3. 创建岩浆粒子效果
                    if (world instanceof net.minecraft.class_3218 serverWorld) {
                        serverWorld.method_14199(
                                class_2398.field_11239,
                                player.method_23317(),
                                player.method_23318() + 1.5,
                                player.method_23321(),
                                100,
                                3.0, 2.0, 3.0,
                                0.2
                        );

                        serverWorld.method_14199(
                                class_2398.field_11240,
                                player.method_23317(),
                                player.method_23318() + 1.0,
                                player.method_23321(),
                                50,
                                2.0, 1.0, 2.0,
                                0.1
                        );
                    }

                    // 4. 播放音效
                    world.method_8396(
                            null,
                            player.method_24515(),
                            class_3417.field_15231,
                            class_3419.field_15248,
                            1.0F,
                            0.7F
                    );

                    // 5. 消耗耐久并清空内容
                    stack.method_7956(MAGMA_BURST_DAMAGE, player, p -> p.method_20236(hand));
                    tag.method_10582("BottleContent", "empty");
                }

                // 设置冷却时间
                player.method_7357().method_7906(stack.method_7909(), MAGMA_BURST_COOLDOWN);

                return class_1271.method_22427(stack);
            }

            return class_1271.method_22430(stack);
        }); // 修复这里：移除了多余的括号
    }
    // 创建潮汐冲击波
    private static void createTidalWave(class_1657 player, class_1937 world) {
        class_243 startPos = player.method_5836(1.0f);
        class_243 lookVec = player.method_5828(1.0f);
        class_243 endPos = startPos.method_1019(lookVec.method_1021(TIDAL_WAVE_RANGE));

        // 检测命中的实体
        class_3966 entityHit = class_1675.method_18075(
                player,
                startPos,
                endPos,
                new class_238(startPos, endPos),
                entity -> !entity.method_7325() && entity.method_5863(),
                TIDAL_WAVE_RANGE
        );

        // 粒子效果
        if (world instanceof net.minecraft.class_3218 serverWorld) {
            // 沿冲击路径生成粒子
            for (int i = 0; i < 20; i++) {
                double progress = i / 20.0 * TIDAL_WAVE_RANGE;
                class_243 particlePos = startPos.method_1019(lookVec.method_1021(progress));

                serverWorld.method_14199(
                        class_2398.field_11202,
                        particlePos.field_1352,
                        particlePos.field_1351,
                        particlePos.field_1350,
                        3,
                        0.5, 0.5, 0.5,
                        0.1
                );

                serverWorld.method_14199(
                        class_2398.field_11247,
                        particlePos.field_1352,
                        particlePos.field_1351,
                        particlePos.field_1350,
                        2,
                        0.3, 0.3, 0.3,
                        0.05
                );
            }
        }

        // 对路径上的实体造成影响
        if (entityHit != null && entityHit.method_17782() instanceof class_1309 target) {
            // 造成伤害
            target.method_5643(player.method_48923().method_48824(), TIDAL_DAMAGE);

            // 击退效果
            class_243 knockbackVec = lookVec.method_1021(TIDAL_KNOCKBACK);
            target.method_5762(knockbackVec.field_1352, knockbackVec.field_1351 * 0.5, knockbackVec.field_1350);

            // 灭火
            target.method_5646();

            // 添加减速效果
            target.method_6092(new class_1293(
                    class_1294.field_5909,
                    60, // 3秒
                    1   // 减速II
            ));
        }

        // 播放冲击命中音效
        world.method_43128(null, endPos.field_1352, endPos.field_1351, endPos.field_1350,
                class_3417.field_14876,
                class_3419.field_15248, 1.0F, 0.7F);
    }

    private static class_3965 raycast(class_1937 world, net.minecraft.class_1657 player, class_3959.class_242 fluidHandling) {
        double reach = player.method_7337() ? 5.0D : 4.5D;
        return world.method_17742(new class_3959(
                player.method_5836(1.0F),
                player.method_5836(1.0F).method_1019(player.method_5828(1.0F).method_1021(reach)),
                class_3959.class_3960.field_17559,
                fluidHandling,
                player
        ));
    }
}