package com.stools.item;

import com.stools.Strangetools;
import com.stools.block.ModBlocks;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.item.*;
import java.util.*;

public class ModItemGroups {

    public static final class_5321<class_1761> TOOLS_GROUP = register("tools_group");
    public static final class_5321<class_1761> ARMOR_GROUP = register("armor_group");

    private static class_5321<class_1761> register(String id) {
        return class_5321.method_29179(class_7924.field_44688, new class_2960(Strangetools.MOD_ID, id));
    }

    public static void registerGroups() {
        final class_1792 toolsIcon = ModItems.TOOLS.get("copper_sword") != null ?
                ModItems.TOOLS.get("copper_sword") :
                class_1802.field_8371;

        class_2378.method_39197(
                class_7923.field_44687,
                TOOLS_GROUP,
                FabricItemGroup.builder()
                        .method_47321(class_2561.method_43471("itemGroup.strangetools.tools_group"))
                        .method_47320(() -> new class_1799(toolsIcon))
                        .method_47317((displayContext, entries) -> {
                            // 按主题分类排序
                            Map<String, List<String>> categoryMap = new LinkedHashMap<>();

                            // 主世界工具
                            categoryMap.put("主世界", Arrays.asList(
                                    "dirt", "copper", "emerald", "lapis", "redstone", "coal",
                                    "obsidian", "prismarine","blue_ice","leather", "rotten_flesh",
                                    "bone", "glass", "slime", "string","amethyst","flint","bedrock"
                            ));

                            // 下界工具
                            categoryMap.put("下界", Arrays.asList(
                                    "netherrack", "quartz", "nether_star","glowstone",
                                    "blaze_powder"
                            ));

                            // 末地工具
                            categoryMap.put("末地", Arrays.asList(
                                    "ender_alloy", "end_stone", "void"
                            ));

                            // 食物＆农作物工具
                            categoryMap.put("食物&农业", Arrays.asList(
                                    "apple", "golden_apple", "enchanted_golden_apple", "melon",
                                    "sweet_berries","glow_berries","carrot","golden_carrot","potato",
                                    "poisonous_potato","beetroot","wheat","dried_kelp","raw_beef",
                                    "chorus_fruit", "cake"
                            ));

                            // 按分类顺序添加工具
                            for (List<String> materials : categoryMap.values()) {
                                for (String material : materials) {
                                    for (String toolId : ModItems.TOOL_IDS) {
                                        if (toolId.startsWith(material + "_")) {
                                            class_1792 tool = ModItems.TOOLS.get(toolId);
                                            if (tool != null) {
                                                entries.method_45421(tool);
                                            }
                                        }
                                    }
                                }
                            }
                        })
                        .method_47324()
        );

        final class_1792 armorIcon = ModItems.ARMORS.get("emerald_chestplate") != null ?
                ModItems.ARMORS.get("emerald_chestplate") :
                class_1802.field_8523;

        class_2378.method_39197(
                class_7923.field_44687,
                ARMOR_GROUP,
                FabricItemGroup.builder()
                        .method_47321(class_2561.method_43471("itemGroup.strangetools.armor_group"))
                        .method_47320(() -> new class_1799(armorIcon))
                        .method_47317((displayContext, entries) -> {
                            List<String> materials = new ArrayList<>();
                            for (String armorId : ModItems.ARMOR_IDS) {
                                String material = armorId.split("_")[0];
                                if (!materials.contains(material)) {
                                    materials.add(material);
                                }
                            }

                            for (String material : materials) {
                                String[] types = {"helmet", "chestplate", "leggings", "boots"};
                                for (String type : types) {
                                    String armorId = material + "_" + type;
                                    if (ModItems.ARMOR_IDS.contains(armorId)) {
                                        class_1792 armor = ModItems.ARMORS.get(armorId);
                                        if (armor != null) {
                                            entries.method_45421(armor);
                                        }
                                    }
                                }
                            }
                        })
                        .method_47324()
        );
    }
    public static void modifyVanillaGroups() {
        // 获取原版原材料组
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(entries -> {
            entries.addAfter(class_1802.field_22020, ModItems.ENDER_ALLOY_SCRAP);
            entries.addAfter(ModItems.ENDER_ALLOY_SCRAP, ModItems.ENDER_ALLOY_INGOT);
            entries.addAfter(class_1802.field_33402, ModItems.RAW_VOID);
            entries.addAfter(ModItems.ENDER_ALLOY_INGOT, ModItems.VOID_INGOT);
            entries.addAfter(class_1802.field_41957, ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE);
            entries.addAfter(class_1802.field_8449,ModItems.VOID_PEARL);
            entries.addAfter(class_1802.field_43220,ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE);
            entries.addAfter(class_1802.field_8695,ModItems.AMETHYST_INGOT);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register(entries -> {
            entries.addAfter(class_1802.field_22019, ModBlocks.VOID_ORE);
            entries.addAfter(ModBlocks.VOID_ORE, ModBlocks.ENDER_ORE);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(entries ->
                entries.addAfter(class_1802.field_8449,ModItems.VOID_PEARL));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(entries ->
                entries.addAfter(class_1802.field_17534,ModItems.SLICE_OF_CAKE));
        }
    }