package com.stools.item;

import com.stools.item.materials.ModToolMaterials;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.item.*;
import com.stools.item.custom.*;
public class ToolFactory {
    public interface Glintable {
        boolean hasGlint();
    }
    public static void registerToolSet(class_1832 material, String materialName) {
        String prefix = materialName.toLowerCase() + "_";

        // 注册全套工具
        ModItems.registerTool(prefix + "sword", createSword(material, prefix + "sword"));
        ModItems.registerTool(prefix + "pickaxe", createPickaxe(material, prefix + "pickaxe"));
        ModItems.registerTool(prefix + "axe", createAxe(material, prefix + "axe"));
        ModItems.registerTool(prefix + "shovel", createShovel(material, prefix + "shovel"));
        ModItems.registerTool(prefix + "hoe", createHoe(material, prefix + "hoe"));
    }

    // 原版攻击速度参考值：
    // 木剑: -2.4F, 钻石剑: -2.4F
    // 木镐: -2.8F, 钻石镐: -2.8F
    // 木斧: -3.2F, 钻石斧: -3.0F
    // 木铲: -3.0F, 钻石铲: -3.0F
    // 木锄: -3.0F, 钻石锄: -3.0F

    public static class_1792 createSword(class_1832 material, String id) {
        boolean hasGlint = material instanceof Glintable glintable && glintable.hasGlint();

        // 皮革剑特殊处理
        if (material == ModToolMaterials.LEATHER) {
            return new LeatherSwordItem(material, 3, -2.4F, new class_1792.class_1793().method_7895(material.method_8025())) {
                @Override
                public String method_7876() {
                    return "item.strangetools." + id;
                }

                @Override
                public boolean method_7886(class_1799 stack) {
                    return hasGlint || super.method_7886(stack);
                }
            };
        }

        // 其他材料保持原逻辑
        return new class_1829(material, 3, -2.4F, new class_1792.class_1793().method_7895(material.method_8025())) {
            @Override
            public String method_7876() {
                return "item.strangetools." + id;
            }

            @Override
            public boolean method_7886(class_1799 stack) {
                return hasGlint || super.method_7886(stack);
            }
        };
    }

    public static class_1792 createPickaxe(class_1832 material, String id) {
        boolean hasGlint = material instanceof Glintable glintable && glintable.hasGlint();

        // 皮革镐特殊处理
        if (material == ModToolMaterials.LEATHER) {
            return new LeatherPickaxeItem(material, 1, -2.8F, new class_1792.class_1793().method_7895(material.method_8025())) {
                @Override
                public String method_7876() {
                    return "item.strangetools." + id;
                }

                @Override
                public boolean method_7886(class_1799 stack) {
                    return hasGlint || super.method_7886(stack);
                }
            };
        }

        // 其他材料保持原逻辑
        return new class_1810(material, 1, -2.8F, new class_1792.class_1793().method_7895(material.method_8025())) {
            @Override
            public String method_7876() {
                return "item.strangetools." + id;
            }

            @Override
            public boolean method_7886(class_1799 stack) {
                return hasGlint || super.method_7886(stack);
            }
        };
    }

    public static class_1792 createAxe(class_1832 material, String id) {
        boolean hasGlint = material instanceof Glintable glintable && glintable.hasGlint();

        // 皮革斧特殊处理
        if (material == ModToolMaterials.LEATHER) {
            return new LeatherAxeItem(material, 5, -3.2F, new class_1792.class_1793().method_7895(material.method_8025())) {
                @Override
                public String method_7876() {
                    return "item.strangetools." + id;
                }

                @Override
                public boolean method_7886(class_1799 stack) {
                    return hasGlint || super.method_7886(stack);
                }
            };
        }

        // 其他材料保持原逻辑（攻击速度计算）
        float attackSpeed;
        int miningLevel = material.method_8024();

        if (miningLevel >= 3) {
            attackSpeed = -3.0F + (miningLevel - 3) * 0.1F;
        } else if (miningLevel == 2) {
            attackSpeed = -3.1F;
        } else {
            attackSpeed = -3.2F;
        }

        return new class_1743(material, 5.0F, attackSpeed, new class_1792.class_1793().method_7895(material.method_8025())) {
            @Override
            public String method_7876() {
                return "item.strangetools." + id;
            }

            @Override
            public boolean method_7886(class_1799 stack) {
                return hasGlint || super.method_7886(stack);
            }
        };
    }

    public static class_1792 createShovel(class_1832 material, String id) {
        boolean hasGlint = material instanceof Glintable glintable && glintable.hasGlint();

        // 皮革铲特殊处理
        if (material == ModToolMaterials.LEATHER) {
            return new LeatherShovelItem(material, 1.5F, -3.0F, new class_1792.class_1793().method_7895(material.method_8025())) {
                @Override
                public String method_7876() {
                    return "item.strangetools." + id;
                }

                @Override
                public boolean method_7886(class_1799 stack) {
                    return hasGlint || super.method_7886(stack);
                }
            };
        }

        // 其他材料保持原逻辑
        return new class_1821(material, 1.5F, -3.0F, new class_1792.class_1793().method_7895(material.method_8025())) {
            @Override
            public String method_7876() {
                return "item.strangetools." + id;
            }

            @Override
            public boolean method_7886(class_1799 stack) {
                return hasGlint || super.method_7886(stack);
            }
        };
    }

    public static class_1792 createHoe(class_1832 material, String id) {
        boolean hasGlint = material instanceof Glintable glintable && glintable.hasGlint();

        // 皮革锄特殊处理
        if (material == ModToolMaterials.LEATHER) {
            return new LeatherHoeItem(material, 0, -3.0F, new class_1792.class_1793().method_7895(material.method_8025())) {
                @Override
                public String method_7876() {
                    return "item.strangetools." + id;
                }

                @Override
                public boolean method_7886(class_1799 stack) {
                    return hasGlint || super.method_7886(stack);
                }
            };
        }

        // 其他材料保持原逻辑
        int attackDamage = (int) material.method_8028();
        int hoeDamage = Math.max(0, attackDamage - 2);

        if (material instanceof ModToolMaterials && material == ModToolMaterials.DIRT) {
            hoeDamage = 0;
        }

        return new class_1794(material, hoeDamage, -3.0F, new class_1792.class_1793().method_7895(material.method_8025())) {
            @Override
            public String method_7876() {
                return "item.strangetools." + id;
            }

            @Override
            public boolean method_7886(class_1799 stack) {
                return hasGlint || super.method_7886(stack);
            }
        };
    }
}