package com.stools.item.custom;

import com.stools.config.ModConfigManager;
import net.minecraft.class_1768;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public class LeatherSwordItem extends class_1829 implements class_1768 {
    private static final String COLOR_KEY = "color";
    private static final int DEFAULT_COLOR = 0xA06540; // 皮革默认颜色

    public LeatherSwordItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public int method_7800(class_1799 stack) {
        class_2487 nbt = stack.method_7941(field_30871);
        if (nbt != null && nbt.method_10573(field_30873, class_2520.field_33253)) {
            return nbt.method_10550(field_30873);
        }
        return field_30872;
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        // 如果开启了染色耐久条，始终显示
        if (ModConfigManager.CONFIG.general.coloredDurabilityBar) {
            return true;
        }

        // 否则使用默认逻辑（只有耐久不满时才显示）
        return super.method_31567(stack);
    }

    @Override
    public int method_31571(class_1799 stack) {
        // 根据配置决定是否使用染色颜色
        if (ModConfigManager.CONFIG.general.coloredDurabilityBar) {
            return method_7800(stack);
        }

        // 默认使用原版耐久条颜色逻辑
        float durabilityRatio = Math.max(0.0F, ((float)stack.method_7936() - (float)stack.method_7919()) / (float)stack.method_7936());
        return class_3532.method_15369(durabilityRatio / 3.0F, 1.0F, 1.0F);
    }
}