package com.stools.item.custom;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.stools.enchantment.ModEnchantments;
import com.stools.item.materials.ModMaceMaterials;
import com.stools.sound.ModSoundEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.entity.*;
import net.minecraft.item.*;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class MaceItem extends class_1792 {
    private static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final Random RANDOM = new Random();

    //属性
    private static final int BASE_DAMAGE = 6; // 基础伤害
    private static final float ATTACK_SPEED = -3.4F; // 攻击速度 = 4.0 - 3.4 = 0.6 (1.65秒冷却)
    private static final float KNOCKBACK_RANGE = 3.5F;
    private static final float KNOCKBACK_POWER = 0.7F;

    private final ModMaceMaterials material;

    public MaceItem(ModMaceMaterials material, class_1793 settings) {
        super(settings);
        this.material = material;
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, e -> e.method_20235(class_1304.field_6173));

        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657) attacker;
            class_1937 world = player.method_37908();

            if (shouldDealAdditionalDamage(player)) {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218) world;

                    class_3414 sound;
                    boolean isHeavySmash = false;

                    if (target.method_24828()) {
                        if (player.field_6017 > 5.0F) {
                            sound = ModSoundEvents.MACE_HEAVY_SMASH_GROUND;
                            isHeavySmash = true;

                            class_2338 groundPos = target.method_24515().method_10074();
                            class_2680 groundState = serverWorld.method_8320(groundPos);

                            serverWorld.method_14199(
                                    new class_2388(class_2398.field_11217, groundState),
                                    target.method_23317(),
                                    target.method_23318(),
                                    target.method_23321(),
                                    50,
                                    0.5,
                                    0.1,
                                    0.5,
                                    0.2
                            );
                        } else {
                            sound = ModSoundEvents.MACE_SMASH_GROUND;
                        }
                    } else {
                        sound = ModSoundEvents.MACE_SMASH_AIR;
                    }

                    serverWorld.method_43128(
                            null,
                            player.method_23317(),
                            player.method_23318(),
                            player.method_23321(),
                            sound,
                            class_3419.field_15248,
                            1.0F,
                            RANDOM.nextFloat() * 0.2F + 0.9F
                    );

                    // 击退效果
                    knockbackNearbyEntities(serverWorld, player, target, isHeavySmash);

                    player.method_5762(0, 0.15, 0);
                    if (player instanceof class_3222) {
                        ((class_3222) player).field_13987.method_14364(
                                new class_2743(player)
                        );
                    }

                    // 防止玩家受到摔落伤害
                    player.field_6017 = 0;
                }
            }
        }
        return true;
    }

    private static void knockbackNearbyEntities(class_1937 world, class_1657 player, class_1297 attacked, boolean isHeavySmash) {
        class_238 box = attacked.method_5829().method_1014(KNOCKBACK_RANGE);
        List<class_1309> entities = world.method_8390(class_1309.class, box, e ->
                e != player && e != attacked &&
                        !(e instanceof class_1531 && ((class_1531)e).method_6912()) &&
                        !player.method_5722(e)
        );

        for (class_1309 entity : entities) {
            class_243 direction = entity.method_19538().method_1020(attacked.method_19538());
            double distance = direction.method_1033();
            double strength = (KNOCKBACK_RANGE - distance) * KNOCKBACK_POWER;

            // 重击时击退翻倍
            if (isHeavySmash) {
                strength *= 2.0;
            }

            // 考虑击退抗性
            strength *= (1.0 - entity.method_26825(class_5134.field_23718));

            if (strength > 0) {
                entity.method_5762(direction.method_1029().field_1352 * strength, 0.2, direction.method_1029().field_1350 * strength);
                if (entity instanceof class_3222) {
                    ((class_3222) entity).field_13987.method_14364(new class_2743(entity));
                }
            }
        }
    }

    public static boolean shouldDealAdditionalDamage(class_1309 attacker) {
        boolean hasSlowFalling = attacker.method_6059(class_1294.field_5906);
        boolean isGliding = attacker.method_6128();

        return attacker.field_6017 > 1.5F && !hasSlowFalling && !isGliding;
    }

    public float getBonusAttackDamage(class_1309 attacker) {
        if (!shouldDealAdditionalDamage(attacker)) {
            return 0.0F;
        }

        float fallDistance = attacker.field_6017;
        float bonusDamage = 0.0F;

        // 分段计算伤害
        if (fallDistance <= 3.0F) {
            bonusDamage = fallDistance * 4.0F;
        } else if (fallDistance <= 8.0F) {
            bonusDamage = 12.0F + (fallDistance - 3.0F) * 2.0F;
        } else {
            bonusDamage = 22.0F + (fallDistance - 8.0F) * 1.0F;
        }

        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657) attacker;
            int densityLevel = class_1890.method_8225(ModEnchantments.DENSITY, player.method_6047());
            bonusDamage += densityLevel * 2.0f; // 每级附魔增加2点伤害
        }
        return bonusDamage;
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214(world, pos) != 0.0F) {
            stack.method_7956(2, miner, e -> e.method_20235(class_1304.field_6173));
        }
        return true;
    }

    @Override
    public int method_7837() {
        return material.getEnchantability();
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return material.getRepairIngredient().method_8093(ingredient);
    }

    @Override
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        Multimap<class_1320, class_1322> modifiers = HashMultimap.create();

        if (slot == class_1304.field_6173) {
            modifiers.put(class_5134.field_23721,
                    new class_1322(field_8006, "Weapon modifier",
                            material.getBaseDamage(), class_1322.class_1323.field_6328));
            modifiers.put(class_5134.field_23723,
                    new class_1322(field_8001, "Weapon modifier",
                            ATTACK_SPEED, class_1322.class_1323.field_6328));
        }
        return modifiers;
    }
}