// ModArmorMaterials.java
package com.stools.item.materials;

import com.stools.Strangetools;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;

public enum ModArmorMaterials implements class_3542, class_1741 {
    EMERALD("emerald", 40, class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 4);
        map.put(class_1738.class_8051.field_41936, 7);
        map.put(class_1738.class_8051.field_41935, 9);
        map.put(class_1738.class_8051.field_41934, 4);
    }), 25, class_3417.field_15103,
            1.0F, 0.0F, () -> class_1856.method_8091(class_1802.field_8687), 0.3f),
    LAPIS("lapis", 30, class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 3);     // 靴子护甲值
        map.put(class_1738.class_8051.field_41936, 6);  // 护腿护甲值
        map.put(class_1738.class_8051.field_41935, 8);// 胸甲护甲值
        map.put(class_1738.class_8051.field_41934, 3);    // 头盔护甲值
    }), 30, class_3417.field_14862,
            0.0F, 0.0F, () -> class_1856.method_8091(class_1802.field_8759), 0.25f),
    COPPER("copper", 20, class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 1);
        map.put(class_1738.class_8051.field_41936, 3);
        map.put(class_1738.class_8051.field_41935, 4);
        map.put(class_1738.class_8051.field_41934, 1);
    }), 12, class_3417.field_14862,
            0.0F, 0.0F, () -> class_1856.method_8091(class_1802.field_27022), 0.1f),
    REDSTONE("redstone", 15, class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 1);
        map.put(class_1738.class_8051.field_41936, 3);
        map.put(class_1738.class_8051.field_41935, 4);
        map.put(class_1738.class_8051.field_41934, 1);
    }), 18, class_3417.field_14862,
            0.0F, 0.0F, () -> class_1856.method_8091(class_1802.field_8725), 0.08f),
    COAL("coal", 12, class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 1);
        map.put(class_1738.class_8051.field_41936, 2);
        map.put(class_1738.class_8051.field_41935, 3);
        map.put(class_1738.class_8051.field_41934, 1);
    }), 10, class_3417.field_14581,
            0.0F, 0.0F, () -> class_1856.method_8091(class_1802.field_8713), 0.15f);

    private static final EnumMap<class_1738.class_8051, Integer> BASE_DURABILITY = class_156.method_654(new EnumMap(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 13);
        map.put(class_1738.class_8051.field_41936, 15);
        map.put(class_1738.class_8051.field_41935, 16);
        map.put(class_1738.class_8051.field_41934, 11);
    });

    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<class_1738.class_8051, Integer> protectionAmounts;
    private final int enchantability;
    private final class_3414 equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<class_1856> repairIngredientSupplier;
    private final float effectPower;

    ModArmorMaterials(String name, int durabilityMultiplier, EnumMap<class_1738.class_8051, Integer> protectionAmounts,
                      int enchantability, class_3414 equipSound, float toughness,
                      float knockbackResistance, Supplier<class_1856> repairIngredientSupplier,
                      float effectPower) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredientSupplier = repairIngredientSupplier;
        this.effectPower = effectPower;
    }

    public float getEffectPower() {
        return effectPower;
    }

    @Override
    public int method_48402(class_1738.class_8051 type) {
        return (Integer)BASE_DURABILITY.get(type) * this.durabilityMultiplier;
    }

    @Override
    public int method_48403(class_1738.class_8051 type) {
        return (Integer)this.protectionAmounts.get(type);
    }

    @Override
    public int method_7699() {
        return this.enchantability;
    }

    @Override
    public class_3414 method_7698() {
        return this.equipSound;
    }

    @Override
    public class_1856 method_7695() {
        return this.repairIngredientSupplier.get();
    }

    @Override
    public String method_7694() {
        return Strangetools.MOD_ID + ":" + this.name;
    }

    @Override
    public float method_7700() {
        return this.toughness;
    }

    @Override
    public float method_24355() {
        return this.knockbackResistance;
    }

    @Override
    public String method_15434() {
        return this.name;
    }
}