package com.stools.mixin;

import com.stools.item.ModItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2609;

@Mixin(class_2609.class)
public class AbstractFurnaceBlockEntityMixin {
    @Inject(method = "createFuelTimeMap", at = @At("TAIL"))
    private static void addFuelItems(CallbackInfoReturnable<Map<class_1792, Integer>> cir) {
        cir.getReturnValue().put(ModItems.RAW_VOID, 3200);
        cir.getReturnValue().put(ModItems.VOID_INGOT, 4200);
        Map<class_1792, Integer> fuelMap = cir.getReturnValue();

        addCoalToolsAsFuel(fuelMap);
    }

    private static void addCoalToolsAsFuel(Map<class_1792, Integer> fuelMap) {
        int fuelTime = 2400;

        fuelMap.put(ModItems.TOOLS.get("coal_sword"), fuelTime);
        fuelMap.put(ModItems.TOOLS.get("coal_pickaxe"), fuelTime);
        fuelMap.put(ModItems.TOOLS.get("coal_axe"), fuelTime);
        fuelMap.put(ModItems.TOOLS.get("coal_shovel"), fuelTime);
        fuelMap.put(ModItems.TOOLS.get("coal_hoe"), fuelTime);
        fuelMap.put(ModItems.ARMORS.get("coal_boots"), fuelTime);
        fuelMap.put(ModItems.ARMORS.get("coal_helmet"), fuelTime);
        fuelMap.put(ModItems.ARMORS.get("coal_chestplate"), fuelTime);
        fuelMap.put(ModItems.ARMORS.get("coal_leggings"), fuelTime);
    }
}