package com.stools.mixin;

import com.stools.item.materials.ModToolMaterials;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1831;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5712;

@Mixin(class_2248.class)
public class BlockMixin {

    private static final ModToolMaterials[] FLAME_MATERIALS = {
            ModToolMaterials.BLAZE_POWDER,
            ModToolMaterials.NETHERRACK,
            ModToolMaterials.COAL,
    };

    @Inject(method = "afterBreak", at = @At("HEAD"), cancellable = true)
    private void afterBreak(class_1937 world, class_1657 player, class_2338 pos, net.minecraft.class_2680 state,
                            net.minecraft.class_2586 blockEntity, class_1799 stack, CallbackInfo ci) {
        if (world.method_8608()) return;

        // 使用模式变量简化类型判断和转换
        if (!(stack.method_7909() instanceof class_1831 tool)) return;

        // 直接通过模式匹配获取ModToolMaterials
        if (!(tool.method_8022() instanceof ModToolMaterials material)) return;

        if (!isFlameTool(material) || !(tool instanceof class_1810)) return;

        // 50%概率触发烧炼效果
        if (world.field_9229.method_43057() < 0.5f) {
            int fortuneLevel = class_1890.method_8225(class_1893.field_9130, stack);
            handleSmeltingDrop((class_3218) world, pos, (class_2248) (Object) this, player, fortuneLevel, ci);
        }
        // 不满足概率时自然保留原版逻辑，无需额外代码
    }

    // 添加@Unique注解标识Mixin特有方法，避免与目标类冲突
    @Unique
    private boolean isFlameTool(ModToolMaterials material) {
        for (ModToolMaterials flameMat : FLAME_MATERIALS) {
            if (material == flameMat) {
                return true;
            }
        }
        return false;
    }

    // 添加@Unique注解，且明确参数含义
    @Unique
    private static void handleSmeltingDrop(class_3218 world, class_2338 pos, class_2248 block, class_1657 player,
                                           int fortuneLevel, CallbackInfo ci) {
        class_1799 rawDrop = new class_1799(block.method_8389());
        if (rawDrop.method_7960()) return;

        Optional<class_3861> recipe = world.method_8433()
                .method_8132(class_3956.field_17546, new class_1277(rawDrop), world);

        if (recipe.isPresent()) {
            // 处理烧炼掉落
            class_1799 smelted = recipe.get().method_8110(world.method_30349()).method_7972();
            int dropCount = calculateDropCount(fortuneLevel, world);
            smelted.method_7939(dropCount);

            class_2248.method_9577(world, pos, smelted);
            world.method_8652(pos, net.minecraft.class_2246.field_10124.method_9564(), 3);
            world.method_33596(player, class_5712.field_28165, pos);

            ci.cancel(); // 仅在有配方时取消原版逻辑
        }
        //无配方时自然执行原版逻辑
    }

    // 添加@Unique注解
    @Unique
    private static int calculateDropCount(int fortuneLevel, class_3218 world) {
        int dropCount = 1;
        if (fortuneLevel > 0 && world.field_9229.method_43048(fortuneLevel + 2) - 1 > 0) {
            dropCount = world.field_9229.method_43048(fortuneLevel + 1) + 1;
        }
        return dropCount;
    }
}
