package com.stools.render;

import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class GlassToolRenderer implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    private static final class_2960 EMPTY_MODEL = new class_2960("strangetools:item/glass_axe_empty");
    private static final class_2960 WATER_MODEL = new class_2960("strangetools:item/glass_axe_water");
    private static final class_2960 LAVA_MODEL = new class_2960("strangetools:item/glass_axe_lava");
    
    @Override
    public void render(class_1799 stack, class_811 mode, class_4587 matrices, 
                       class_4597 vertexConsumers, int light, int overlay) {
        
        // 获取物品渲染器
        class_918 itemRenderer = class_310.method_1551().method_1480();
        
        // 根据NBT内容选择模型
        class_2960 modelId = EMPTY_MODEL;
        if (stack.method_7985()) {
            class_2487 nbt = stack.method_7969();
            if (nbt.method_10545("BottleContent")) {
                String content = nbt.method_10558("BottleContent");
                if ("water".equals(content)) {
                    modelId = WATER_MODEL;
                } else if ("lava".equals(content)) {
                    modelId = LAVA_MODEL;
                }
            }
        }
        
        // 获取模型并渲染
        class_1087 model = class_310.method_1551().method_1554().getModel(modelId);
        itemRenderer.method_23179(stack, mode, false, matrices, vertexConsumers, light, overlay, model);
    }
}