package com.stools.wordgen;

import com.stools.Strangetools;
import com.stools.block.ModBlocks;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5455;
import net.minecraft.class_5843;
import net.minecraft.class_6646;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6794;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import net.minecraft.world.gen.placementmodifier.*;
import java.util.List;

public class ModWorldGen {
    public static final class_3825 END_STONE_RULE = new class_3819(class_2246.field_10471);
    private static boolean isRegistered = false;

    // 矿石注册键
    public static final class_5321<class_2975<?, ?>> ORE_ENDER_KEY = class_5321.method_29179(
            class_7924.field_41239,
            new class_2960(Strangetools.MOD_ID, "ore_ender")
    );
    public static final class_5321<class_2975<?, ?>> ORE_VOID_KEY = class_5321.method_29179(
            class_7924.field_41239,
            new class_2960(Strangetools.MOD_ID, "ore_void")
    );

    public static final class_5321<class_6796> ORE_ENDER_PLACED_KEY = class_5321.method_29179(
            class_7924.field_41245,
            new class_2960(Strangetools.MOD_ID, "ore_ender_placed")
    );
    public static final class_5321<class_6796> ORE_VOID_PLACED_KEY = class_5321.method_29179(
            class_7924.field_41245,
            new class_2960(Strangetools.MOD_ID, "ore_void_placed")
    );

    public static void register(class_5455 registries) {
        if (isRegistered) return;

        // 获取配置特征注册表
        class_2378<class_2975<?, ?>> configuredRegistry = registries.method_30530(class_7924.field_41239);
        // 获取放置特征注册表
        class_2378<class_6796> placedRegistry = registries.method_30530(class_7924.field_41245);

        // 注册配置特征
        class_2378.method_10230(
                configuredRegistry,
                ORE_ENDER_KEY.method_29177(),
                new class_2975<>(
                        class_3031.field_13517,
                        new class_3124(
                                END_STONE_RULE,
                                ModBlocks.ENDER_ORE.method_9564(),
                                3
                        )
                )
        );

        class_2378.method_10230(
                configuredRegistry,
                ORE_VOID_KEY.method_29177(),
                new class_2975<>(
                        class_3031.field_13517,
                        new class_3124(
                                END_STONE_RULE,
                                ModBlocks.VOID_ORE.method_9564(),
                                5
                        )
                )
        );

        // 注册放置特征
        class_2378.method_10230(
                placedRegistry,
                ORE_ENDER_PLACED_KEY.method_29177(),
                new class_6796(
                        class_6880.method_40223(configuredRegistry.method_31140(ORE_ENDER_KEY)),
                        List.of(
                                class_6793.method_39623(5),
                                class_5450.method_39639(),
                                class_6795.method_39634(
                                        class_5843.method_33841(5),
                                        class_5843.method_33841(40)
                                ),
                                class_6792.method_39614()
                        )
                )
        );

        class_2378.method_10230(
                placedRegistry,
                ORE_VOID_PLACED_KEY.method_29177(),
                new class_6796(
                        class_6880.method_40223(configuredRegistry.method_31140(ORE_VOID_KEY)),
                        List.of(
                                class_6793.method_39623(10),
                                class_5450.method_39639(),
                                class_6795.method_39634(
                                        class_5843.method_33841(5),
                                        class_5843.method_33841(25)
                                ),
                                class_6792.method_39614(),
                                class_6794.method_39628(
                                        class_2350.field_11033,
                                        class_6646.field_35696,
                                        8
                                )
                        )
                )
        );

        isRegistered = true;
        Strangetools.LOGGER.info("World generation features registered successfully");
    }

    public static void registerBiomeModifications() {
        if (!isRegistered) {
            Strangetools.LOGGER.error("World generation features not registered! Skipping biome modifications.");
            return;
        }

        Strangetools.LOGGER.info("Registering biome modifications...");

        // 末影矿添加到所有末地生物群系
        BiomeModifications.addFeature(
                BiomeSelectors.foundInTheEnd(),
                class_2893.class_2895.field_13176,
                ORE_ENDER_PLACED_KEY
        );

        // 虚空矿只添加到末地小型岛屿生物群系
        BiomeModifications.addFeature(
                BiomeSelectors.includeByKey(class_1972.field_9457),
                class_2893.class_2895.field_13176,
                ORE_VOID_PLACED_KEY
        );

        Strangetools.LOGGER.info("Biome modifications registered successfully");
    }
}