/*
 * Decompiled with CFR 0.152.
 */
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModArmorMaterials;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.joml.Vector3f;

public class ArmorEffectHandler {
    private static final Map<ModArmorMaterials, List<class_1293>> ARMOR_EFFECTS_MAP = new EnumMap<ModArmorMaterials, List<class_1293>>(ModArmorMaterials.class);
    private static final Random RANDOM;

    public static void register() {
        ArmorEffectHandler.initArmorEffects();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return true;
            }
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                ArmorEffectHandler.applyReflectiveDamage(entity, attacker);
            }
            return true;
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            for (class_1657 player : world.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                ArmorEffectHandler.applyContinuousEffects(player);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }
            ArmorEffectHandler.applyContinuousEffects((class_1657)player);
        });
    }

    private static void initArmorEffects() {
    }

    private static void applyReflectiveDamage(class_1309 wearer, class_1309 attacker) {
        class_3218 serverWorld;
        ModArmorMaterials mat;
        float totalEffectPower = 0.0f;
        ModArmorMaterials primaryMaterial = null;
        for (class_1799 armor : wearer.method_5661()) {
            class_1738 armorItem;
            class_1792 class_17922 = armor.method_7909();
            if (!(class_17922 instanceof class_1738) || !((class_17922 = (armorItem = (class_1738)class_17922).method_7686()) instanceof ModArmorMaterials)) continue;
            mat = (ModArmorMaterials)class_17922;
            totalEffectPower += mat.getEffectPower();
            if (primaryMaterial != null) continue;
            primaryMaterial = mat;
        }
        if (totalEffectPower > 0.0f && primaryMaterial != null) {
            if (primaryMaterial == ModArmorMaterials.EMERALD) {
                float reflectChance = ModConfigManager.CONFIG.armorEffects.armorReflectChance / 100.0f;
                if (wearer.method_6051().method_43057() < reflectChance) {
                    float reflectDamage = ModConfigManager.CONFIG.armorEffects.armorReflectDamage;
                    attacker.method_5643(wearer.method_48923().method_48818((class_1297)wearer), reflectDamage);
                    wearer.method_6092(new class_1293(class_1294.field_5912, 40, 0, true, false));
                }
            }
            if (primaryMaterial == ModArmorMaterials.LAPIS) {
                float xpStealChance = 0.3f;
                if (wearer.method_6051().method_43057() < xpStealChance) {
                    int stolenXp = 1 + RANDOM.nextInt(3);
                    if (attacker instanceof class_1657) {
                        ((class_1657)attacker).method_7255(-stolenXp);
                    }
                    if (wearer instanceof class_1657) {
                        ((class_1657)wearer).method_7255(stolenXp);
                        mat = wearer.method_37908();
                        if (mat instanceof class_3218) {
                            serverWorld = (class_3218)mat;
                            serverWorld.method_14199((class_2394)class_2398.field_11215, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
                        }
                    }
                }
            }
            if (primaryMaterial == ModArmorMaterials.COPPER) {
                if (wearer.method_37908().method_8546()) {
                    float lightningChance = ModConfigManager.CONFIG.armorEffects.copperPushChance / 100.0f;
                    if (RANDOM.nextFloat() < lightningChance) {
                        attacker.method_6005(0.5, wearer.method_23317() - attacker.method_23317(), wearer.method_23321() - attacker.method_23321());
                        wearer.method_37908().method_8396(null, attacker.method_24515(), class_3417.field_14865, class_3419.field_15248, 0.5f, 1.5f);
                    }
                }
                float cleanseChance = ModConfigManager.CONFIG.armorEffects.copperCleanseChance / 100.0f;
                if (RANDOM.nextFloat() < cleanseChance) {
                    Optional<class_1291> effectToRemove = wearer.method_6088().keySet().stream().filter(effect -> !effect.method_5573()).findAny();
                    effectToRemove.ifPresent(effect -> {
                        wearer.method_6016(effect);
                        class_1937 patt0$temp = wearer.method_37908();
                        if (patt0$temp instanceof class_3218) {
                            class_3218 serverWorld = (class_3218)patt0$temp;
                            serverWorld.method_14199((class_2394)class_2398.field_11211, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 5, 0.3, 0.3, 0.3, 0.1);
                        }
                    });
                }
            }
            if (primaryMaterial == ModArmorMaterials.REDSTONE) {
                float slowChance = 0.12f;
                if (RANDOM.nextFloat() < slowChance) {
                    attacker.method_6092(new class_1293(class_1294.field_5909, 40, 0, false, false, true));
                    serverWorld = wearer.method_37908();
                    if (serverWorld instanceof class_3218) {
                        class_3218 serverWorld2 = serverWorld;
                        class_2390 dustEffect = new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
                        serverWorld2.method_14199((class_2394)dustEffect, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 5, 0.3, 0.3, 0.3, 0.1);
                    }
                }
                float repairChance = 0.15f;
                if (RANDOM.nextFloat() < repairChance) {
                    for (class_1799 armor : wearer.method_5661()) {
                        if (!armor.method_7986()) continue;
                        armor.method_7974(armor.method_7919() - 1);
                    }
                    wearer.method_37908().method_8396(null, wearer.method_24515(), class_3417.field_26980, class_3419.field_15248, 0.6f, 1.8f);
                }
            }
        }
        if (primaryMaterial == ModArmorMaterials.COAL) {
            float igniteChance = 0.15f + totalEffectPower * 0.05f;
            if (RANDOM.nextFloat() < igniteChance) {
                int fireTime = 1 + RANDOM.nextInt(3);
                attacker.method_5639(fireTime * 20);
                class_1937 class_19372 = wearer.method_37908();
                if (class_19372 instanceof class_3218) {
                    serverWorld = (class_3218)class_19372;
                    serverWorld.method_14199((class_2394)class_2398.field_11240, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 10, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }
    }

    private static void applyContinuousEffects(class_1657 player) {
        for (Map.Entry<ModArmorMaterials, List<class_1293>> entry : ARMOR_EFFECTS_MAP.entrySet()) {
            ModArmorMaterials material = entry.getKey();
            List<class_1293> effects = entry.getValue();
            if (!ArmorEffectHandler.hasFullSet(player, material)) continue;
            for (class_1293 effect : effects) {
                ArmorEffectHandler.applyEffectWithRefresh(player, effect);
            }
        }
    }

    private static void applyEffectWithRefresh(class_1657 player, class_1293 effect) {
        class_1293 current = player.method_6112(effect.method_5579());
        if (current == null || current.method_5584() <= 10) {
            player.method_6092(new class_1293(effect.method_5579(), 20, effect.method_5578(), false, false, true));
        }
    }

    private static boolean hasFullSet(class_1657 player, ModArmorMaterials material) {
        return ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6169), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6174), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6172), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6166), material);
    }

    private static boolean isArmorOfMaterial(class_1799 stack, ModArmorMaterials material) {
        class_1738 armorItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7686() == material;
    }

    static {
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.EMERALD, List.of(new class_1293(class_1294.field_5926, 100, 1, false, false, true)));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.LAPIS, List.of(new class_1293(class_1294.field_5907, 100, 0, false, false, true)));
        RANDOM = new Random();
    }
}

