/*
 * Decompiled with CFR 0.152.
 */
package com.stools.item;

import com.stools.item.ModItems;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class ModTrades {
    private static final List<String> MAIN_WORLD_MATERIALS = Arrays.asList("dirt", "copper", "emerald", "lapis", "redstone", "coal", "obsidian", "prismarine", "rotten_flesh", "bone", "glass", "slime", "string", "amethyst", "flint", "blue_ice");
    private static final List<String> ARMOR_MATERIALS = Arrays.asList("copper", "emerald", "lapis", "redstone");
    private static final List<String> TOOL_TYPES = Arrays.asList("sword", "pickaxe", "axe", "shovel", "hoe");

    public static void registerTrades() {
        ModTrades.registerToolsmithTrades();
        ModTrades.registerArmorerTrades();
        ModTrades.registerWanderingTraderTrades();
    }

    private static void registerToolsmithTrades() {
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17064, (int)1, factories -> ModTrades.addToolsForMaterials(factories, Arrays.asList("dirt", "coal", "string", "rotten_flesh", "flint"), 1, 4));
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17064, (int)3, factories -> ModTrades.addToolsForMaterials(factories, Arrays.asList("copper", "lapis", "redstone", "bone", "slime", "glass", "blue_ice"), 3, 7));
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17064, (int)5, factories -> ModTrades.addToolsForMaterials(factories, Arrays.asList("emerald", "obsidian", "prismarine", "amethyst"), 5, 12));
    }

    private static void addToolsForMaterials(List<class_3853.class_1652> factories, List<String> materials, int baseEmeralds, int maxUses) {
        for (String material : materials) {
            if (!MAIN_WORLD_MATERIALS.contains(material)) continue;
            for (String toolType : TOOL_TYPES) {
                String toolId = material + "_" + toolType;
                class_1792 tool = ModItems.TOOLS.get(toolId);
                if (tool == null) continue;
                int emeraldCount = toolType.equals("axe") || toolType.equals("sword") ? baseEmeralds + 2 : baseEmeralds;
                factories.add((entity, random) -> new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)tool), maxUses, 8, 0.05f));
            }
        }
    }

    private static void registerArmorerTrades() {
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)1, factories -> ModTrades.addArmorForMaterial(factories, "copper", 4, 8));
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)2, factories -> ModTrades.addArmorForMaterial(factories, "redstone", 6, 10));
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)3, factories -> ModTrades.addArmorForMaterial(factories, "lapis", 8, 12));
        TradeOfferHelper.registerVillagerOffers((class_3852)class_3852.field_17052, (int)5, factories -> ModTrades.addArmorForMaterial(factories, "emerald", 12, 15));
    }

    private static void addArmorForMaterial(List<class_3853.class_1652> factories, String material, int baseEmeralds, int maxUses) {
        String[] armorTypes;
        if (!ARMOR_MATERIALS.contains(material)) {
            return;
        }
        for (String armorType : armorTypes = new String[]{"helmet", "chestplate", "leggings", "boots"}) {
            String armorId = material + "_" + armorType;
            class_1792 armor = ModItems.ARMORS.get(armorId);
            if (armor == null) continue;
            int emeraldCount = armorType.equals("chestplate") ? baseEmeralds + 3 : (armorType.equals("helmet") || armorType.equals("leggings") ? baseEmeralds + 1 : baseEmeralds);
            factories.add((entity, random) -> new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)armor), maxUses, 10, 0.05f));
        }
    }

    private static void registerWanderingTraderTrades() {
        TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> {
            factories.add((entity, random) -> {
                String toolType;
                String material = MAIN_WORLD_MATERIALS.get(random.method_43048(MAIN_WORLD_MATERIALS.size()));
                String toolId = material + "_" + (toolType = TOOL_TYPES.get(random.method_43048(TOOL_TYPES.size())));
                class_1792 tool = ModItems.TOOLS.get(toolId);
                if (tool == null) {
                    return null;
                }
                int emeraldCount = 3 + random.method_43048(6);
                return new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)tool), 3, 5, 0.1f);
            });
            factories.add((entity, random) -> {
                if (random.method_43057() < 0.3f) {
                    String material = ARMOR_MATERIALS.get(random.method_43048(ARMOR_MATERIALS.size()));
                    String armorType = (new String[]{"helmet", "chestplate", "leggings", "boots"})[random.method_43048(4)];
                    String armorId = material + "_" + armorType;
                    class_1792 armor = ModItems.ARMORS.get(armorId);
                    if (armor == null) {
                        return null;
                    }
                    int emeraldCount = 8 + random.method_43048(8);
                    return new class_1914(new class_1799((class_1935)class_1802.field_8687, emeraldCount), new class_1799((class_1935)armor), 2, 8, 0.1f);
                }
                return null;
            });
        });
    }
}

