/*
 * Decompiled with CFR 0.152.
 */
package com.stools.datagen;

import com.stools.item.ModItems;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class ModZhCnLangProvider
extends FabricLanguageProvider {
    public ModZhCnLangProvider(FabricDataOutput dataOutput) {
        super(dataOutput, "zh_cn");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(ModItems.MACE, "\u91cd\u9524");
        translationBuilder.add("itemGroup.strangetools.tools_group", "\u5947\u5947\u602a\u602a\u7684\u5de5\u5177");
        translationBuilder.add("itemGroup.strangetools.armor_group", "\u5947\u5947\u602a\u602a\u7684\u76d4\u7532");
        this.generateItemTranslations(translationBuilder, ModItems.TOOL_IDS);
        this.generateItemTranslations(translationBuilder, ModItems.ARMOR_IDS);
    }

    private void generateItemTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, List<String> itemIds) {
        for (String itemId : itemIds) {
            int lastIndex = itemId.lastIndexOf(95);
            if (lastIndex == -1) continue;
            String material = itemId.substring(0, lastIndex);
            String type = itemId.substring(lastIndex + 1);
            String materialName = this.getMaterialName(material);
            String typeName = this.getTypeName(type);
            if (materialName == null || typeName == null) continue;
            translationBuilder.add("item.strangetools." + itemId, materialName + typeName);
        }
    }

    private String getMaterialName(String material) {
        return switch (material) {
            case "copper" -> "\u94dc";
            case "emerald" -> "\u7eff\u5b9d\u77f3";
            case "lapis" -> "\u9752\u91d1\u77f3";
            case "redstone" -> "\u7ea2\u77f3";
            case "quartz" -> "\u77f3\u82f1";
            case "coal" -> "\u7164\u70ad";
            case "cake" -> "\u86cb\u7cd5";
            case "obsidian" -> "\u9ed1\u66dc\u77f3";
            case "prismarine" -> "\u6d77\u6676\u77f3";
            case "rotten_flesh" -> "\u8150\u8089";
            case "glowstone" -> "\u8424\u77f3";
            case "blaze_powder" -> "\u70c8\u7130\u7c89";
            case "golden_apple" -> "\u91d1\u82f9\u679c";
            case "enchanted_golden_apple" -> "\u9644\u9b54\u91d1\u82f9\u679c";
            case "bedrock" -> "\u57fa\u5ca9";
            case "bone" -> "\u9aa8\u5934";
            case "nether_star" -> "\u4e0b\u754c\u4e4b\u661f";
            case "netherrack" -> "\u4e0b\u754c\u5ca9";
            default -> null;
        };
    }

    private String getTypeName(String type) {
        return switch (type) {
            case "sword" -> "\u5251";
            case "pickaxe" -> "\u9550";
            case "axe" -> "\u65a7";
            case "shovel" -> "\u9539";
            case "hoe" -> "\u9504";
            case "helmet" -> "\u5934\u76d4";
            case "chestplate" -> "\u80f8\u7532";
            case "leggings" -> "\u62a4\u817f";
            case "boots" -> "\u9774\u5b50";
            default -> null;
        };
    }
}

