/*
 * Decompiled with CFR 0.152.
 */
package com.stools.datagen;

import com.stools.item.ModItems;
import java.util.List;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class ModJaJpLangProvider
extends FabricLanguageProvider {
    public ModJaJpLangProvider(FabricDataOutput dataOutput) {
        super(dataOutput, "ja_jp");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add(ModItems.MACE, "\u91cd\u69cc\uff08\u3058\u3085\u3046\u3064\u3044\uff09");
        translationBuilder.add("itemGroup.strangetools.tools_group", "\u5909\u308f\u3063\u305f\u30c4\u30fc\u30eb");
        translationBuilder.add("itemGroup.strangetools.armor_group", "\u5909\u308f\u3063\u305f\u93a7");
        this.generateItemTranslations(translationBuilder, ModItems.TOOL_IDS);
        this.generateItemTranslations(translationBuilder, ModItems.ARMOR_IDS);
    }

    private void generateItemTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, List<String> itemIds) {
        for (String itemId : itemIds) {
            int lastIndex = itemId.lastIndexOf(95);
            if (lastIndex == -1) continue;
            String material = itemId.substring(0, lastIndex);
            String type = itemId.substring(lastIndex + 1);
            String materialName = this.getMaterialName(material);
            String typeName = this.getTypeName(type);
            if (materialName == null || typeName == null) continue;
            translationBuilder.add("item.strangetools." + itemId, materialName + typeName);
        }
    }

    private String getMaterialName(String material) {
        return switch (material) {
            case "copper" -> "\u9285\uff08\u3069\u3046\uff09";
            case "emerald" -> "\u30a8\u30e1\u30e9\u30eb\u30c9";
            case "lapis" -> "\u30e9\u30d4\u30b9\u30e9\u30ba\u30ea";
            case "redstone" -> "\u30ec\u30c3\u30c9\u30b9\u30c8\u30fc\u30f3";
            case "quartz" -> "\u30af\u30a9\u30fc\u30c4";
            case "coal" -> "\u77f3\u70ad\uff08\u305b\u304d\u305f\u3093\uff09";
            case "cake" -> "\u30b1\u30fc\u30ad";
            case "obsidian" -> "\u9ed2\u66dc\u77f3\uff08\u3053\u304f\u3088\u3046\u305b\u304d\uff09";
            case "prismarine" -> "\u30d7\u30ea\u30ba\u30de\u30ea\u30f3";
            case "rotten_flesh" -> "\u8150\u8089\uff08\u3075\u306b\u304f\uff09";
            case "glowstone" -> "\u30b0\u30ed\u30fc\u30b9\u30c8\u30fc\u30f3";
            case "blaze_powder" -> "\u30d6\u30ec\u30a4\u30ba\u306e\u7c89";
            case "golden_apple" -> "\u91d1\u306e\u30ea\u30f3\u30b4";
            case "enchanted_golden_apple" -> "\u9b54\u6cd5\u4ed8\u304d\u91d1\u306e\u30ea\u30f3\u30b4";
            case "bedrock" -> "\u5ca9\u76e4\uff08\u304c\u3093\u3070\u3093\uff09";
            case "bone" -> "\u9aa8\uff08\u307b\u306d\uff09";
            case "nether_star" -> "\u30cd\u30b6\u30fc\u30b9\u30bf\u30fc";
            case "netherrack" -> "\u30cd\u30b6\u30fc\u30ec\u30c3\u30af";
            case "glass" -> "\u30ac\u30e9\u30b9";
            default -> null;
        };
    }

    private String getTypeName(String type) {
        return switch (type) {
            case "sword" -> "\u5263\uff08\u3051\u3093\uff09";
            case "pickaxe" -> "\u3064\u308b\u306f\u3057";
            case "axe" -> "\u65a7\uff08\u304a\u306e\uff09";
            case "shovel" -> "\u30b7\u30e3\u30d9\u30eb";
            case "hoe" -> "\u304f\u308f";
            case "helmet" -> "\u515c\uff08\u304b\u3076\u3068\uff09";
            case "chestplate" -> "\u80f8\u5f53\u3066\uff08\u3080\u306a\u3042\u3066\uff09";
            case "leggings" -> "\u817f\u7532\uff08\u3082\u3082\u304b\u3076\u3068\uff09";
            case "boots" -> "\u9774\uff08\u304f\u3064\uff09";
            default -> null;
        };
    }
}

