/*
 * Decompiled with CFR 0.152.
 */
package com.stools.item.custom;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.stools.enchantment.ModEnchantments;
import com.stools.item.materials.ModMaceMaterials;
import com.stools.sound.ModSoundEvents;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;

public class MaceItem
extends class_1792 {
    private static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final Random RANDOM = new Random();
    private static final int BASE_DAMAGE = 6;
    private static final float ATTACK_SPEED = -3.4f;
    private static final float KNOCKBACK_RANGE = 3.5f;
    private static final float KNOCKBACK_POWER = 0.7f;
    private final ModMaceMaterials material;

    public MaceItem(ModMaceMaterials material, class_1792.class_1793 settings) {
        super(settings);
        this.material = material;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, e -> e.method_20235(class_1304.field_6173));
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            class_1937 world = player.method_37908();
            if (MaceItem.shouldDealAdditionalDamage((class_1309)player) && world instanceof class_3218) {
                class_3414 sound;
                class_3218 serverWorld = (class_3218)world;
                boolean isHeavySmash = false;
                if (target.method_24828()) {
                    if (player.field_6017 > 5.0f) {
                        sound = ModSoundEvents.MACE_HEAVY_SMASH_GROUND;
                        isHeavySmash = true;
                        class_2338 groundPos = target.method_24515().method_10074();
                        class_2680 groundState = serverWorld.method_8320(groundPos);
                        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, groundState), target.method_23317(), target.method_23318(), target.method_23321(), 50, 0.5, 0.1, 0.5, 0.2);
                    } else {
                        sound = ModSoundEvents.MACE_SMASH_GROUND;
                    }
                } else {
                    sound = ModSoundEvents.MACE_SMASH_AIR;
                }
                serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, 1.0f, RANDOM.nextFloat() * 0.2f + 0.9f);
                MaceItem.knockbackNearbyEntities((class_1937)serverWorld, player, (class_1297)target, isHeavySmash);
                player.method_5762(0.0, 0.15, 0.0);
                if (player instanceof class_3222) {
                    ((class_3222)player).field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                }
                player.field_6017 = 0.0f;
            }
        }
        return true;
    }

    private static void knockbackNearbyEntities(class_1937 world, class_1657 player, class_1297 attacked, boolean isHeavySmash) {
        class_238 box = attacked.method_5829().method_1014(3.5);
        List entities = world.method_8390(class_1309.class, box, e -> e != player && e != attacked && (!(e instanceof class_1531) || !((class_1531)e).method_6912()) && !player.method_5722((class_1297)e));
        for (class_1309 entity : entities) {
            class_243 direction = entity.method_19538().method_1020(attacked.method_19538());
            double distance = direction.method_1033();
            double strength = (3.5 - distance) * (double)0.7f;
            if (isHeavySmash) {
                strength *= 2.0;
            }
            if (!((strength *= 1.0 - entity.method_26825(class_5134.field_23718)) > 0.0)) continue;
            entity.method_5762(direction.method_1029().field_1352 * strength, 0.2, direction.method_1029().field_1350 * strength);
            if (!(entity instanceof class_3222)) continue;
            ((class_3222)entity).field_13987.method_14364((class_2596)new class_2743((class_1297)entity));
        }
    }

    public static boolean shouldDealAdditionalDamage(class_1309 attacker) {
        boolean hasSlowFalling = attacker.method_6059(class_1294.field_5906);
        boolean isGliding = attacker.method_6128();
        return attacker.field_6017 > 1.5f && !hasSlowFalling && !isGliding;
    }

    public float getBonusAttackDamage(class_1309 attacker) {
        if (!MaceItem.shouldDealAdditionalDamage(attacker)) {
            return 0.0f;
        }
        float fallDistance = attacker.field_6017;
        float bonusDamage = 0.0f;
        bonusDamage = fallDistance <= 3.0f ? fallDistance * 4.0f : (fallDistance <= 8.0f ? 12.0f + (fallDistance - 3.0f) * 2.0f : 22.0f + (fallDistance - 8.0f) * 1.0f);
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            int densityLevel = class_1890.method_8225((class_1887)ModEnchantments.DENSITY, (class_1799)player.method_6047());
            bonusDamage += (float)densityLevel * 2.0f;
        }
        return bonusDamage;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214((class_1922)world, pos) != 0.0f) {
            stack.method_7956(2, miner, e -> e.method_20235(class_1304.field_6173));
        }
        return true;
    }

    public int method_7837() {
        return this.material.getEnchantability();
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return this.material.getRepairIngredient().method_8093(ingredient);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == class_1304.field_6173) {
            modifiers.put((Object)class_5134.field_23721, (Object)new class_1322(ATTACK_DAMAGE_MODIFIER_ID, "Weapon modifier", (double)this.material.getBaseDamage(), class_1322.class_1323.field_6328));
            modifiers.put((Object)class_5134.field_23723, (Object)new class_1322(ATTACK_SPEED_MODIFIER_ID, "Weapon modifier", (double)-3.4f, class_1322.class_1323.field_6328));
        }
        return modifiers;
    }
}

