package com.stools;

import com.stools.entity.ModEntities;
import com.stools.item.ModItems;
import com.stools.render.entity.EnderPhantomRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1768;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_953;

public class StrangetoolsClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
        registerLeatherToolsColorProvider();
		ModItems.TOOLS.forEach((id, item) -> {
			if (id.startsWith("glass_")) {
				class_5272.method_27879(item,
						new class_2960("strangetools", "bottle_content"),
						(stack, world, entity, seed) -> {
							if (!stack.method_7985()) return 0.0F;

							class_2487 nbt = stack.method_7969();
							if (!nbt.method_10545("BottleContent")) return 0.0F;

							String content = nbt.method_10558("BottleContent");

							// 只处理水和空瓶状态
							return "water".equals(content) ? 1.0F : 0.0F;
						}
				);
			}
		});
		EntityRendererRegistry.register(ModEntities.ENDER_PHANTOM, EnderPhantomRenderer::new);
		// 注册虚影珍珠渲染器（使用原版投掷物品渲染器）
		EntityRendererRegistry.register(ModEntities.VOID_PEARL,
				context -> new class_953<>(context, 1.5f, true)); //渲染尺寸
	}
    private void registerLeatherToolsColorProvider() {
        // 为所有皮革工具注册颜色提供器
        ModItems.TOOLS.forEach((id, item) -> {
            if (id.startsWith("leather_")) {
                ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
                    if (tintIndex == 0 && stack.method_7909() instanceof class_1768 dyeableItem) {
                        return dyeableItem.method_7800(stack);
                    }
                    return -1; // 默认颜色（白色）
                }, item);
            }
        });
    }
}