// ModAdvancementsProvider.java
package com.stools.datagen;

import com.stools.Strangetools;
import com.stools.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.function.Consumer;

public class ModAdvancementsProvider extends FabricAdvancementProvider {
    public ModAdvancementsProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateAdvancement(Consumer<class_161> consumer) {
        // 主成就
        class_161 root = class_161.class_162.method_707()
                .method_697(
                        class_1802.field_8465,
                        class_2561.method_43471("advancement.strangetools.root.title"),
                        class_2561.method_43471("advancement.strangetools.root.description"),
                        new class_2960("minecraft", "textures/block/sandstone.png"),
                        class_189.field_1254,
                        true, true, false
                )
                .method_709("has_any_tool", class_2066.class_2068.method_8959(
                        ModItems.TOOLS.get("dirt_sword"),
                        ModItems.TOOLS.get("copper_sword"),
                        ModItems.TOOLS.get("cake_sword"))
                )
                .method_694(consumer, Strangetools.MOD_ID + ":root");

        class_161 toolBranch = class_161.class_162.method_707()
                .method_701(root)
                .method_697(
                        class_1802.field_8403, // 使用更合适的图标
                        class_2561.method_43471("advancement.strangetools.tool_master.title"),
                        class_2561.method_43471("advancement.strangetools.tool_master.description"),
                        null,
                        class_189.field_1254,
                        true, true, false
                )
                .method_709("has_sword", class_2066.class_2068.method_8959(ModItems.TOOLS.get("dirt_sword")))
                .method_709("has_pickaxe", class_2066.class_2068.method_8959(ModItems.TOOLS.get("copper_pickaxe")))
                .method_709("has_axe", class_2066.class_2068.method_8959(ModItems.TOOLS.get("cake_axe")))
                .method_34884(new String[][]{{"has_sword", "has_pickaxe", "has_axe"}})
                .method_694(consumer, Strangetools.MOD_ID + ":tool_master");

        createToolAdvancement(consumer, toolBranch, "dirt_sword", "anything_tool");
        createToolAdvancement(consumer, toolBranch, "cake_sword", "edible_weapon");
        createObsidianToolAdvancement(consumer, toolBranch);

        // 盔甲分支
        class_161 armorBranch = class_161.class_162.method_707()
                .method_701(root)
                .method_697(
                        class_1802.field_8523, // 使用更合适的图标
                        class_2561.method_43471("advancement.strangetools.armor_master.title"),
                        class_2561.method_43471("advancement.strangetools.armor_master.description"),
                        null,
                        class_189.field_1254,
                        true, true, false
                )
                .method_709("has_helmet", class_2066.class_2068.method_8959(ModItems.ARMORS.get("copper_helmet")))
                .method_709("has_chestplate", class_2066.class_2068.method_8959(ModItems.ARMORS.get("redstone_chestplate")))
                .method_709("has_leggings", class_2066.class_2068.method_8959(ModItems.ARMORS.get("lapis_leggings")))
                .method_34884(new String[][]{{"has_helmet", "has_chestplate", "has_leggings"}})
                .method_694(consumer, Strangetools.MOD_ID + ":armor_master");

        createArmorAdvancement(consumer, armorBranch, "redstone", "redstone_armor");
        createFullArmorSetAdvancement(consumer, armorBranch, "lapis", "full_weird_set");

        // 高级材料分支
        class_161 alloyBranch = createMaterialAdvancement(consumer, root,
                class_1802.field_22020, "alloy_master");

        createMaterialAdvancement(consumer, alloyBranch, ModItems.ENDER_ALLOY_INGOT,
                "ender_alloy_master");

        createToolAdvancement(consumer, alloyBranch, "ender_alloy_sword", "ender_alloy_tool");

        // 探索分支
        class_161 exploreBranch = createMaterialAdvancement(consumer, root,
                class_1802.field_8634, "explorer");

        createMaterialAdvancement(consumer, exploreBranch, ModItems.VOID_PEARL, "void_explorer");
    }

    private void createToolAdvancement(Consumer<class_161> consumer,
                                       class_161 parent,
                                       String toolId,
                                       String advancementId) {

        class_1935 toolItem = ModItems.TOOLS.get(toolId);
        if (toolItem == null) return;

        class_161.class_162.method_707()
                .method_701(parent)
                .method_697(
                        toolItem,
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".title"),
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".description"),
                        null,
                        class_189.field_1250,
                        true, true, false
                )
                .method_709("has_tool", class_2066.class_2068.method_8959(toolItem))
                .method_694(consumer, Strangetools.MOD_ID + ":" + advancementId);
    }

    private void createArmorAdvancement(Consumer<class_161> consumer,
                                        class_161 parent,
                                        String material,
                                        String advancementId) {

        class_1935 armorItem = ModItems.ARMORS.get(material + "_chestplate");
        if (armorItem == null) return;

        class_161.class_162.method_707()
                .method_701(parent)
                .method_697(
                        armorItem,
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".title"),
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".description"),
                        null,
                        class_189.field_1254,
                        true, true, false
                )
                .method_709("has_armor", class_2066.class_2068.method_8959(armorItem))
                .method_694(consumer, Strangetools.MOD_ID + ":" + advancementId);
    }

    private class_161 createMaterialAdvancement(Consumer<class_161> consumer,
                                                  class_161 parent,
                                                  class_1935 item,
                                                  String advancementId) {

        return class_161.class_162.method_707()
                .method_701(parent)
                .method_697(
                        item,
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".title"),
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".description"),
                        null,
                        class_189.field_1250,
                        true, true, false
                )
                .method_709("has_item", class_2066.class_2068.method_8959(item))
                .method_694(consumer, Strangetools.MOD_ID + ":" + advancementId);
    }

    private class_161 createFullArmorSetAdvancement(Consumer<class_161> consumer,
                                                      class_161 parent,
                                                      String material,
                                                      String advancementId) {

        class_1935 helmet = ModItems.ARMORS.get(material + "_helmet");
        class_1935 chestplate = ModItems.ARMORS.get(material + "_chestplate");
        class_1935 leggings = ModItems.ARMORS.get(material + "_leggings");
        class_1935 boots = ModItems.ARMORS.get(material + "_boots");
        if (helmet == null || chestplate == null || leggings == null || boots == null) {
            return null;
        }

        return class_161.class_162.method_707()
                .method_701(parent)
                .method_697(
                        boots,
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".title"),
                        class_2561.method_43471("advancement.strangetools." + advancementId + ".description"),
                        null,
                        class_189.field_1250,
                        true, true, false
                )
                .method_709("has_full_set", class_2066.class_2068.method_8959(
                        helmet, chestplate, leggings, boots
                ))
                .method_694(consumer, Strangetools.MOD_ID + ":" + advancementId);
    }

    private void createObsidianToolAdvancement(Consumer<class_161> consumer, class_161 parent) {
        class_1935 obsidianPickaxe = ModItems.TOOLS.get("obsidian_pickaxe");
        if (obsidianPickaxe == null) return;

        class_161.class_162.method_707()
                .method_701(parent)
                .method_697(
                        obsidianPickaxe,
                        class_2561.method_43471("advancement.strangetools.obsidian_tool.title"),
                        class_2561.method_43471("advancement.strangetools.obsidian_tool.description"),
                        null,
                        class_189.field_1250,
                        true, true, false
                )
                .method_709("has_obsidian_pickaxe", class_2066.class_2068.method_8959(obsidianPickaxe))
                .method_694(consumer, Strangetools.MOD_ID + ":obsidian_tool");
    }
}