package com.stools.datagen;

import com.stools.block.ModBlocks;
import com.stools.integration.FarmerDelightIntegration;
import com.stools.item.ModItems;
import com.terraformersmc.modmenu.util.mod.Mod;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;

public class ModModelsProvider extends FabricModelProvider {
    public ModModelsProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25641(ModBlocks.ENDER_ORE);
        blockStateModelGenerator.method_25641(ModBlocks.VOID_ORE);
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(ModItems.SLICE_OF_CAKE,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.TEST_ITEM,class_4943.field_22939);
        itemModelGenerator.method_25733(ModItems.ENDER_ALLOY_INGOT,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.ENDER_ALLOY_SCRAP,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.VOID_INGOT,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.WATER_INGOT,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.LAVA_INGOT,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.RAW_VOID,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.VOID_PEARL,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE,class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.AMETHYST_INGOT,class_4943.field_22938);
        for (String toolId : ModItems.TOOL_IDS) {
            if (toolId.startsWith("glass_")) continue; // 跳过玻璃工具
            if (toolId.startsWith("leather_")) continue; // 跳过皮革工具
            class_1792 item = ModItems.TOOLS.get(toolId);
            if (item != null) {
                    itemModelGenerator.method_25733(item, class_4943.field_22939);
                }
            }
        // 盔甲模型
        for (String armorId : ModItems.ARMOR_IDS) {
            class_1792 item = ModItems.ARMORS.get(armorId);
            if (item instanceof class_1738 armorItem) {
                itemModelGenerator.method_48523(armorItem);
            }
        }
    }
}