package com.stools.datagen;

import com.stools.Strangetools;
import com.stools.block.ModBlocks;
import com.stools.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8074;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModRecipesProvider extends FabricRecipeProvider {
    public static final class_6862<class_1792> POTIONS_TAG = class_6862.method_40092(class_7924.field_41197, new class_2960(Strangetools.MOD_ID, "potions"));
    public static final class_6862<class_1792> DIRT_TAG = class_6862.method_40092(class_7924.field_41197, new class_2960(Strangetools.MOD_ID, "dirt"));
    public static final List<class_1935> ENDER_ORE = List.of(ModBlocks.ENDER_ORE);
    public static final List<class_1935> VOID_ORE = List.of(ModBlocks.VOID_ORE);
    public static final List<class_1935> VOID_INGOT = List.of(ModItems.RAW_VOID);

    public ModRecipesProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void method_10419(Consumer<class_2444> exporter) {
        method_36233(exporter, ENDER_ORE, class_7800.field_40642, ModItems.ENDER_ALLOY_SCRAP, 0.7f, 200, "ender_scrap");
        method_36234(exporter, ENDER_ORE, class_7800.field_40642, ModItems.ENDER_ALLOY_SCRAP, 0.7f, 200, "ender_scrap");
        method_36233(exporter, VOID_ORE, class_7800.field_40642, ModItems.VOID_INGOT, 0.7f, 200, "VOID_INGOT_ingot");
        method_36234(exporter, VOID_ORE, class_7800.field_40642, ModItems.VOID_INGOT, 0.7f, 200, "VOID_INGOT_ingot");
        method_36233(exporter, VOID_INGOT, class_7800.field_40642, ModItems.VOID_INGOT, 0.7f, 200, "VOID_INGOT_ingot");
        method_36234(exporter, VOID_INGOT, class_7800.field_40642, ModItems.VOID_INGOT, 0.7f, 200, "VOID_INGOT_ingot");
        generateToolRecipes(exporter, "potion", POTIONS_TAG);
        generateToolRecipes(exporter, "dirt", DIRT_TAG);
        generateToolRecipes(exporter, "copper", class_1802.field_27022);
        generateToolRecipes(exporter, "emerald", class_1802.field_8687);
        generateToolRecipes(exporter, "lapis", class_1802.field_8759);
        generateToolRecipes(exporter, "redstone", class_1802.field_8725);
        generateToolRecipes(exporter, "quartz", class_1802.field_8155);
        generateToolRecipes(exporter, "coal", class_1802.field_8713);
        generateToolRecipes(exporter, "cake", class_1802.field_17534);
        generateToolRecipes(exporter, "obsidian", class_1802.field_8281);
        generateToolRecipes(exporter, "prismarine", class_1802.field_8662);
        generateToolRecipes(exporter, "rotten_flesh", class_1802.field_8511);
        generateToolRecipes(exporter, "glowstone", class_1802.field_8601);
        generateToolRecipes(exporter, "blaze_powder", class_1802.field_8814);
        generateToolRecipes(exporter, "apple", class_1802.field_8279);
        generateToolRecipes(exporter, "golden_apple", class_1802.field_8463);
        generateToolRecipes(exporter, "bedrock", class_1802.field_8542);
        generateToolRecipes(exporter, "bone", class_1802.field_8606);
        generateToolRecipes(exporter, "nether_star", class_1802.field_8137);
        generateToolRecipes(exporter, "netherrack", class_1802.field_8328);
        generateToolRecipes(exporter, "glass", class_1802.field_8280);
        generateToolRecipes(exporter, "slime", class_1802.field_8777);
        generateToolRecipes(exporter, "string", class_1802.field_8276);
        generateToolRecipes(exporter, "ender_alloy", ModItems.ENDER_ALLOY_INGOT);
        generateToolRecipes(exporter, "end_stone", class_1802.field_20399);
        generateToolRecipes(exporter, "chorus_fruit", class_1802.field_8233);
        generateToolRecipes(exporter, "void", ModItems.VOID_INGOT);
        generateToolRecipes(exporter, "melon", class_1802.field_8497);
        generateToolRecipes(exporter, "sweet_berries", class_1802.field_16998);
        generateToolRecipes(exporter, "glow_berries", class_1802.field_28659);
        generateToolRecipes(exporter, "carrot", class_1802.field_8179);
        generateToolRecipes(exporter, "golden_carrot", class_1802.field_8071);
        generateToolRecipes(exporter, "potato", class_1802.field_8567);
        generateToolRecipes(exporter, "poisonous_potato", class_1802.field_8635);
        generateToolRecipes(exporter, "amethyst", ModItems.AMETHYST_INGOT);
        generateToolRecipes(exporter, "flint", class_1802.field_8145);
        generateToolRecipes(exporter, "wheat", class_1802.field_8861);
        generateToolRecipes(exporter, "beetroot", class_1802.field_8186);
        generateToolRecipes(exporter, "dried_kelp", class_1802.field_8551);
        generateToolRecipes(exporter, "blue_ice", class_1802.field_8178);
        generateToolRecipes(exporter, "leather", class_1802.field_8745);
        generateToolRecipes(exporter, "raw_beef", class_1802.field_8046);
        generateToolRecipes(exporter, "steak", class_1802.field_8176);
        generateToolRecipes(exporter, "lava", ModItems.LAVA_INGOT);
        generateToolRecipes(exporter, "water", ModItems.WATER_INGOT);


        generateArmorRecipes(exporter, "emerald", class_1802.field_8687);
        generateArmorRecipes(exporter, "lapis", class_1802.field_8759);
        generateArmorRecipes(exporter, "copper", class_1802.field_27022);
        generateArmorRecipes(exporter, "redstone", class_1802.field_8725);
        generateArmorRecipes(exporter, "coal", class_1802.field_8713);
        generateArmorRecipes(exporter, "obsidian", class_1802.field_8281);

        class_2447.method_10436(class_7800.field_40642, ModItems.ENDER_ALLOY_INGOT, 1)
                .method_10439("AAA")
                .method_10439("AOE")
                .method_10439("EEE")
                .method_10434('E', class_1802.field_8281)
                .method_10434('O', class_1802.field_8634)
                .method_10434('A', ModItems.ENDER_ALLOY_SCRAP)
                .method_10429(method_32807(class_1802.field_8281), method_10426(class_1802.field_8281))
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_10429(method_32807(ModItems.ENDER_ALLOY_SCRAP), method_10426(ModItems.ENDER_ALLOY_SCRAP))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "ender_alloy_ingot_recipe"));
        class_2447.method_10436(class_7800.field_40642, ModItems.ENDER_ALLOY_INGOT, 1)
                .method_10439("EEE")
                .method_10439("EVE")
                .method_10439("EEE")
                .method_10434('E', class_1802.field_8634)
                .method_10434('V', ModItems.VOID_INGOT)
                .method_10429(method_32807(class_1802.field_8634), method_10426(class_1802.field_8634))
                .method_10429(method_32807(ModItems.VOID_INGOT), method_10426(ModItems.VOID_INGOT))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "void_pearl_recipe"));

        class_2447.method_10436(class_7800.field_40642, ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE, 2)
                .method_10439("DED")
                .method_10439("DSD")
                .method_10439("DDD")
                .method_10434('E', ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE)
                .method_10434('D', class_1802.field_8477)
                .method_10434('S', class_1802.field_20399)
                .method_10429(method_32807(ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE), method_10426(ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE))
                .method_10429(method_32807(class_1802.field_8477), method_10426(class_1802.field_8477))
                .method_10429(method_32807(class_1802.field_20399), method_10426(class_1802.field_20399))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "ender_alloy_upgrade_recipe"));
        class_2447.method_10436(class_7800.field_40642, ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE, 2)
                .method_10439("DED")
                .method_10439("DSD")
                .method_10439("DDD")
                .method_10434('E', ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE)
                .method_10434('D', class_1802.field_8279)
                .method_10434('S', class_1802.field_8463)
                .method_10429(method_32807(ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE), method_10426(ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE))
                .method_10429(method_32807(class_1802.field_8279), method_10426(class_1802.field_8279))
                .method_10429(method_32807(class_1802.field_8463), method_10426(class_1802.field_8463))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "golden_apple_upgrade_recipe"));
        class_2447.method_10436(class_7800.field_40642, ModItems.AMETHYST_INGOT, 1)
                .method_10439("AAA")
                .method_10439("AIA")
                .method_10439("AAA")
                .method_10434('A', class_1802.field_27063)
                .method_10434('I', class_1802.field_8620)
                .method_10429(method_32807(class_1802.field_27063), method_10426(class_1802.field_27063))
                .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "amethyst_ingot_recipe"));
        class_2447.method_10436(class_7800.field_40642, ModItems.LAVA_INGOT, 1)
                .method_10439("LLL")
                .method_10439("L I")
                .method_10439("III")
                .method_10434('L', class_1802.field_8187)
                .method_10434('I', class_1802.field_8695)
                .method_10429(method_32807(class_1802.field_8187), method_10426(class_1802.field_8187))
                .method_10429(method_32807(class_1802.field_8695), method_10426(class_1802.field_8695))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "lava_ingot_recipe"));
        class_2447.method_10436(class_7800.field_40642, ModItems.WATER_INGOT, 1)
                .method_10439("WWW")
                .method_10439("W I")
                .method_10439("III")
                .method_10434('W', class_1802.field_8705)
                .method_10434('I', class_1802.field_8620)
                .method_10429(method_32807(class_1802.field_8705), method_10426(class_1802.field_8705))
                .method_10429(method_32807(class_1802.field_8620), method_10426(class_1802.field_8620))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, "water_ingot_recipe"));


        generateToolUpgradeRecipes(exporter,
                "ender_alloy",
                this::getDiamondTool,
                toolType -> ModItems.TOOLS.get("ender_alloy_" + toolType),
                ModItems.ENDER_ALLOY_INGOT,
                ModItems.ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE);
        generateToolUpgradeRecipes(exporter,
                "nether_star",
                this::getNetheriteTool,
                toolType -> ModItems.TOOLS.get("nether_star_" + toolType),
                class_1802.field_8137,
                class_1802.field_41946);
        generateToolUpgradeRecipes(exporter,
                "enchanted_golden_apple",
                toolType -> ModItems.TOOLS.get("golden_apple_" + toolType),
                toolType -> ModItems.TOOLS.get("enchanted_golden_apple_" + toolType),
                class_1802.field_8367,
                ModItems.APPLE_UPGRADE_SMITHING_TEMPLATE);
        generateToolUpgradeRecipes(exporter,
                "golden_apple",
                toolType -> ModItems.TOOLS.get("apple_" + toolType),
                toolType -> ModItems.TOOLS.get("golden_apple_" + toolType),
                class_1802.field_8695,
                class_1802.field_8463);

        // 牛肉 -> 熟牛肉(牛排)
        String[] toolTypes = {"sword", "pickaxe", "axe", "shovel", "hoe"};
        for (String toolType : toolTypes) {
            class_1792 rawTool = ModItems.TOOLS.get("raw_beef_" + toolType);
            class_1792 cookedTool = ModItems.TOOLS.get("steak_" + toolType);

            if (rawTool != null && cookedTool != null) {
                // 1. 熔炉配方
                class_2454.method_17802(
                                class_1856.method_8091(rawTool),
                                class_7800.field_40638,
                                cookedTool,
                                0.35f, // 经验值
                                200    // 烹饪时间（刻）
                        )
                        .method_10469(method_32807(rawTool), method_10426(rawTool))
                        .method_17972(exporter, new class_2960(
                                Strangetools.MOD_ID,
                                "steak_" + toolType + "_from_smelting"
                        ));

                // 2. 烟熏炉配方
                class_2454.method_35918(
                                class_1856.method_8091(rawTool),
                                class_7800.field_40638,
                                cookedTool,
                                0.35f, // 经验值
                                100    // 烹饪时间（刻）
                        )
                        .method_10469(method_32807(rawTool), method_10426(rawTool))
                        .method_17972(exporter, new class_2960(
                                Strangetools.MOD_ID,
                                "steak_" + toolType + "_from_smoking"
                        ));

                // 3. 营火配方
                class_2454.method_35916(
                                class_1856.method_8091(rawTool),
                                class_7800.field_40638,
                                cookedTool,
                                0.35f, // 经验值
                                600    // 烹饪时间（刻）
                        )
                        .method_10469(method_32807(rawTool), method_10426(rawTool))
                        .method_17972(exporter, new class_2960(
                                Strangetools.MOD_ID,
                                "steak_" + toolType + "_from_campfire_cooking"
                        ));
            }
        }
    }

    private void generateArmorRecipes(Consumer<class_2444> exporter, String material, class_1792 materialItem) {
        generateArmorPieceRecipe(exporter, material, "helmet",
                "EEE", "E E", materialItem);

        generateArmorPieceRecipe(exporter, material, "chestplate",
                "E E", "EEE", "EEE", materialItem);

        generateArmorPieceRecipe(exporter, material, "leggings",
                "EEE", "E E", "E E", materialItem);

        generateArmorPieceRecipe(exporter, material, "boots",
                "E E", "E E", materialItem);
    }

    private void generateArmorPieceRecipe(Consumer<class_2444> exporter,
                                          String material,
                                          String type,
                                          String pattern1,
                                          String pattern2,
                                          class_1792 materialItem) {
        generateArmorPieceRecipe(exporter, material, type, pattern1, pattern2, "", materialItem);
    }

    private void generateArmorPieceRecipe(Consumer<class_2444> exporter,
                                          String material,
                                          String type,
                                          String pattern1,
                                          String pattern2,
                                          String pattern3,
                                          class_1792 materialItem) {
        class_2447 builder = class_2447.method_10437(
                class_7800.field_40639,
                ModItems.ARMORS.get(material + "_" + type)
        );

        if (!pattern1.isEmpty()) builder.method_10439(pattern1);
        if (!pattern2.isEmpty()) builder.method_10439(pattern2);
        if (!pattern3.isEmpty()) builder.method_10439(pattern3);

        builder.method_10434('E', materialItem)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_" + type));
    }

    private void generateToolRecipes(Consumer<class_2444> exporter,
                                     String material,
                                     class_6862<class_1792> materialTag) {
        // 剑
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_sword"))
                .method_10439(" M ")
                .method_10439(" M ")
                .method_10439(" S ")
                .method_10433('M', materialTag)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_sword"));

        // 镐
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_pickaxe"))
                .method_10439("MMM")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10433('M', materialTag)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_pickaxe"));

        // 斧
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_axe"))
                .method_10439("MM ")
                .method_10439("MS ")
                .method_10439(" S ")
                .method_10433('M', materialTag)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_axe"));

        // 锹
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_shovel"))
                .method_10439(" M ")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10433('M', materialTag)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_shovel"));

        // 锄
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_hoe"))
                .method_10439("MM ")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10433('M', materialTag)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_hoe"));
    }

    // 重载方法 - 支持物品
    private void generateToolRecipes(Consumer<class_2444> exporter,
                                     String material,
                                     class_1935 materialItem) {
        // 剑
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_sword"))
                .method_10439(" M ")
                .method_10439(" M ")
                .method_10439(" S ")
                .method_10434('M', materialItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_sword"));

        // 镐
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_pickaxe"))
                .method_10439("MMM")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10434('M', materialItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_pickaxe"));

        // 斧
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_axe"))
                .method_10439("MM ")
                .method_10439("MS ")
                .method_10439(" S ")
                .method_10434('M', materialItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_axe"));

        // 锹
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_shovel"))
                .method_10439(" M ")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10434('M', materialItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_shovel"));

        // 锄
        class_2447.method_10437(class_7800.field_40638, ModItems.TOOLS.get(material + "_hoe"))
                .method_10439("MM ")
                .method_10439(" S ")
                .method_10439(" S ")
                .method_10434('M', materialItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429(method_32807(materialItem), method_10426(materialItem))
                .method_17972(exporter, new class_2960(Strangetools.MOD_ID, material + "_hoe"));
    }

    // 辅助方法：获取对应的工具
    private class_1792 getDiamondTool(String toolType) {
        return switch (toolType) {
            case "sword" -> class_1802.field_8802;
            case "pickaxe" -> class_1802.field_8377;
            case "axe" -> class_1802.field_8556;
            case "shovel" -> class_1802.field_8250;
            case "hoe" -> class_1802.field_8527;
            default -> throw new IllegalArgumentException("未知工具类型: " + toolType);
        };
    }
    private class_1792 getNetheriteTool(String toolType) {
        return switch (toolType) {
            case "sword" -> class_1802.field_22022;
            case "pickaxe" -> class_1802.field_22024;
            case "axe" -> class_1802.field_22025;
            case "shovel" -> class_1802.field_22023;
            case "hoe" -> class_1802.field_22026;
            default -> throw new IllegalArgumentException("未知工具类型: " + toolType);
        };
    }
    /**
     * 生成工具升级配方
     *
     * @param materialName 材料名称（用于配方ID）
     * @param baseToolGetter 基础工具获取函数
     * @param resultToolGetter 结果工具获取函数
     * @param upgradeMaterial 升级材料
     * @param template 升级模板
     */
    private void generateToolUpgradeRecipes(Consumer<class_2444> exporter,
                                            String materialName,
                                            Function<String, class_1792> baseToolGetter,
                                            Function<String, class_1792> resultToolGetter,
                                            class_1792 upgradeMaterial,
                                            class_1792 template) {
        String[] toolTypes = {"sword", "pickaxe", "axe", "shovel", "hoe"};

        for (String toolType : toolTypes) {
            class_1792 baseTool = baseToolGetter.apply(toolType);
            class_1792 resultTool = resultToolGetter.apply(toolType);

            if (baseTool == null || resultTool == null) {
                continue; // 跳过无效的工具类型
            }

            class_8074.method_48535(
                            class_1856.method_8091(template),
                            class_1856.method_8091(baseTool),
                            class_1856.method_8091(upgradeMaterial),
                            class_7800.field_40638,
                            resultTool
                    )
                    .method_48536(method_32807(baseTool), method_10426(baseTool))
                    .method_48536(method_32807(upgradeMaterial), method_10426(upgradeMaterial))
                    .method_48537(exporter, new class_2960(Strangetools.MOD_ID,
                            materialName + "_" + toolType + "_upgrade"));
        }
    }
}