package com.stools.entity;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3218;

public class EnderPhantomEntity extends class_1297 {
    private UUID playerUuid;
    private int lifetime;
    private class_1657 playerRef;

    public EnderPhantomEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
        this.field_5960 = true;
        this.method_5648(false);
        this.method_5684(true);
    }

    public EnderPhantomEntity(class_1937 world, class_1657 player) {
        this(ModEntities.ENDER_PHANTOM, world);

        // 确保玩家不为 null
        if (player == null) {
            this.method_31472();
            return;
        }

        this.playerUuid = player.method_5667();
        this.playerRef = player;
        this.method_33574(player.method_19538());
        this.method_36456(player.method_36454());
        this.method_36457(player.method_36455());
        this.method_5880(false);
        this.method_5803(true);
        this.lifetime = 60; // 3秒生命周期
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (!method_37908().method_8608()) {
            // 如果 UUID 为空，立即丢弃实体
            if (playerUuid == null) {
                this.method_31472();
                return;
            }

            if (this.lifetime-- <= 0) {
                this.method_31472();
                return;
            }

            // 确保玩家引用有效
            if (playerRef == null) {
                // 尝试重新获取玩家（无需强制类型转换）
                playerRef = method_37908().method_18470(playerUuid);

                // 如果仍然找不到玩家，丢弃实体
                if (playerRef == null) {
                    this.method_31472();
                    return;
                }
            }

            // 跟随玩家位置
            if (this.field_6012 % 5 == 0) {
                this.method_33574(playerRef.method_19538());
            }

            // 每5tick生成粒子效果
            if (this.field_6012 % 5 == 0 && method_37908() instanceof class_3218 serverWorld) {
                serverWorld.method_14199(class_2398.field_23190,
                        this.method_23317(), this.method_23318() + 1, this.method_23321(),
                        5, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    @Override
    protected void method_5693() {}

    @Override
    protected void method_5749(class_2487 nbt) {
        if (nbt.method_25928("OwnerUUID")) {
            this.playerUuid = nbt.method_25926("OwnerUUID");
        } else {
            // 如果NBT中没有UUID，设为默认值（虽然不应该发生）
            this.playerUuid = UUID.randomUUID();
        }
        this.lifetime = nbt.method_10550("Lifetime");
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        if (playerUuid != null) {
            nbt.method_25927("OwnerUUID", playerUuid);
        }
        nbt.method_10569("Lifetime", lifetime);
    }

    @Override
    public class_2596<class_2602> method_18002() {
        return new class_2604(this);
    }

    public UUID getPlayerUuid() {
        // 确保返回值不为null
        return playerUuid != null ? playerUuid : UUID.randomUUID();
    }
}