package com.stools.event;

import com.stools.config.ModConfigManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8103;
import com.stools.item.materials.ModArmorMaterials;
import org.joml.Vector3f;

import java.util.*;

public class ArmorEffectHandler {
    private static final Map<ModArmorMaterials, List<class_1293>> ARMOR_EFFECTS_MAP =
            new EnumMap<>(ModArmorMaterials.class);

    static {
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.EMERALD, List.of(
                new class_1293(class_1294.field_5926, 100, 1, false, false, true)
        ));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.LAPIS, List.of(
                new class_1293(class_1294.field_5907, 100, 0, false, false, true)
        ));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.OBSIDIAN, List.of(
                new class_1293(class_1294.field_5907, 100, 0, false, false, true),
                new class_1293(class_1294.field_5909, 100, 0, false, false, true)
        ));
    }

    private static final Random RANDOM = new Random();

    public static void register() {
        initArmorEffects();

        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return true;
            }

            // 黑曜石盔甲爆炸免疫处理
            if (source.method_48789(class_8103.field_42249) && hasAnyObsidianArmor(entity)) {
                // 消耗每件黑曜石盔甲10%耐久
                for (class_1799 armor : entity.method_5661()) {
                    if (isObsidianArmor(armor)) {
                        int maxDamage = armor.method_7936();
                        int damageToApply = maxDamage / 10; // 10%耐久消耗
                        armor.method_7974(armor.method_7919() + damageToApply);

                        if (armor.method_7919() >= maxDamage) {
                            armor.method_7934(1); // 盔甲损坏
                        }
                    }
                }

                        // 播放爆炸吸收效果
                if (entity.method_37908() instanceof class_3218 serverWorld) {
                    serverWorld.method_14199(class_2398.field_11237,
                            entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(),
                            20, 0.5, 0.5, 0.5, 0.1);
                    serverWorld.method_8396(null, entity.method_24515(),
                            class_3417.field_14785,
                            class_3419.field_15248, 0.8f, 0.5f);
                }

                return false; // 取消爆炸伤害
            }

            if (source.method_5529() instanceof class_1309 attacker) {
                applyReflectiveDamage(entity, attacker, amount);
            }
            return true;
        });

        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }

            if (!(world instanceof class_3218)) return;

            for (class_1657 player : world.method_18456()) {
                if (player instanceof class_3222) {
                    applyContinuousEffects(player);
                    applyObsidianFullSetEffects(player);
                }
            }
        });

        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills ||
                    !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }

            applyContinuousEffects(player);
        });
    }

    private static void initArmorEffects() {
        // 可扩展添加更多盔甲效果
    }

    private static void applyReflectiveDamage(class_1309 wearer, class_1309 attacker, float damageAmount) {
        // 1. 检查煤炭盔甲
        int coalArmorCount = 0;
        for (class_1799 armor : wearer.method_5661()) {
            if (armor.method_7909() instanceof class_1738 armorItem &&
                    armorItem.method_7686() == ModArmorMaterials.COAL) {
                coalArmorCount++;
            }
        }

        // 如果有煤炭盔甲，触发效果
        if (coalArmorCount > 0) {
            float igniteChance = 0.15f + (coalArmorCount * 0.05f); // 基础15% + 每件盔甲增加5%
            if (RANDOM.nextFloat() < igniteChance) {
                int fireTime = 1 + RANDOM.nextInt(3); // 1-3秒燃烧时间
                attacker.method_5639(fireTime * 20); // 转换为游戏刻

                // 粒子效果
                if (wearer.method_37908() instanceof class_3218 serverWorld) {
                    serverWorld.method_14199(class_2398.field_11240,
                            attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(),
                            10, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }

        // 2. 检查是否穿了一整套盔甲（同一种材料，不包括煤炭）
        ModArmorMaterials fullSetMaterial = null;

        // 检查头盔
        class_1799 headStack = wearer.method_6118(class_1304.field_6169);
        ModArmorMaterials headMaterial = getArmorMaterial(headStack);

        // 检查胸甲
        class_1799 chestStack = wearer.method_6118(class_1304.field_6174);
        ModArmorMaterials chestMaterial = getArmorMaterial(chestStack);

        // 检查护腿
        class_1799 legsStack = wearer.method_6118(class_1304.field_6172);
        ModArmorMaterials legsMaterial = getArmorMaterial(legsStack);

        // 检查靴子
        class_1799 feetStack = wearer.method_6118(class_1304.field_6166);
        ModArmorMaterials feetMaterial = getArmorMaterial(feetStack);

        // 只有当四件都是同一种材料时才算整套（排除煤炭）
        if (headMaterial != null && headMaterial != ModArmorMaterials.COAL &&
                headMaterial == chestMaterial &&
                headMaterial == legsMaterial &&
                headMaterial == feetMaterial) {
            fullSetMaterial = headMaterial;
        }

        // 没有整套盔甲，直接返回
        if (fullSetMaterial == null) {
            return;
        }

        // 3. 根据整套盔甲材料触发对应效果
        switch (fullSetMaterial) {
            case EMERALD:
                float dropChance = ModConfigManager.CONFIG.armorEffects.emeraldDropBaseChance / 100f;
                dropChance += damageAmount * 0.01f;
                dropChance = Math.min(dropChance, 0.5f);

                if (wearer.method_6051().method_43057() < dropChance) {
                    int dropCount = Math.max(1,
                            (int) (damageAmount * ModConfigManager.CONFIG.armorEffects.emeraldDamageMultiplier));
                    dropCount = Math.min(dropCount, 5);

                    if (wearer.method_37908() instanceof class_3218 serverWorld) {
                        class_1542 emeraldDrop = new class_1542(
                                serverWorld,
                                wearer.method_23317(),
                                wearer.method_23318() + 0.5,
                                wearer.method_23321(),
                                new class_1799(class_1802.field_8687, dropCount)
                        );
                        serverWorld.method_8649(emeraldDrop);

                        serverWorld.method_14199(class_2398.field_11211,
                                wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(),
                                15, 0.5, 0.5, 0.5, 0.1);

                        serverWorld.method_8396(null, wearer.method_24515(),
                                class_3417.field_14627,
                                class_3419.field_15248, 0.8f, 1.2f);
                    }
                }
                break;

            case LAPIS:
                // 青金石盔甲专属效果：经验窃取
                float xpStealChance = 0.3f;
                if (wearer.method_6051().method_43057() < xpStealChance) {
                    int stolenXp = 1 + RANDOM.nextInt(3);

                    if (attacker instanceof class_1657) {
                        ((class_1657) attacker).method_7255(-stolenXp);
                    }
                    if (wearer instanceof class_1657) {
                        ((class_1657) wearer).method_7255(stolenXp);

                        if (wearer.method_37908() instanceof class_3218 serverWorld) {
                            serverWorld.method_14199(class_2398.field_11215,
                                    wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(),
                                    10, 0.5, 0.5, 0.5, 0.1);
                        }
                    }
                }
                break;

            case COPPER:
                // 效果1: 简易导电 - 雷暴天气小概率击退敌人
                if (wearer.method_37908().method_8546()) {
                    float lightningChance = ModConfigManager.CONFIG.armorEffects.copperPushChance / 100f;
                    if (RANDOM.nextFloat() < lightningChance) {
                        attacker.method_6005(0.5f,
                                wearer.method_23317() - attacker.method_23317(),
                                wearer.method_23321() - attacker.method_23321());
                        wearer.method_37908().method_8396(null, attacker.method_24515(),
                                class_3417.field_14865,
                                class_3419.field_15248, 0.5f, 1.5f);
                    }
                }

                // 效果2: 基础净化 - 概率清除一个负面效果
                float cleanseChance = ModConfigManager.CONFIG.armorEffects.copperCleanseChance / 100f;
                if (RANDOM.nextFloat() < cleanseChance) {
                    Optional<class_1291> effectToRemove = wearer.method_6088().keySet().stream()
                            .filter(effect -> !effect.method_5573())
                            .findAny();
                    effectToRemove.ifPresent(effect -> {
                        wearer.method_6016(effect);
                        if (wearer.method_37908() instanceof class_3218 serverWorld) {
                            serverWorld.method_14199(class_2398.field_11211,
                                    wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(),
                                    5, 0.3, 0.3, 0.3, 0.1);
                        }
                    });
                }
                break;

            case REDSTONE:
                // 效果1: 微弱红石脉冲 - 小概率给予攻击者短暂缓慢
                float slowChance = 0.12f;
                if (RANDOM.nextFloat() < slowChance) {
                    attacker.method_6092(new class_1293(
                            class_1294.field_5909,
                            40, 0, false, false, true
                    ));

                    if (wearer.method_37908() instanceof class_3218 serverWorld) {
                        class_2390 dustEffect = new class_2390(
                                new Vector3f(1.0f, 0.0f, 0.0f),
                                1.0f
                        );

                        serverWorld.method_14199(
                                dustEffect,
                                attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(),
                                5, 0.3, 0.3, 0.3, 0.1
                        );
                    }
                }

                // 效果2: 能量反馈 - 被攻击时回复少量耐久
                float repairChance = 0.15f;
                if (RANDOM.nextFloat() < repairChance) {
                    for (class_1799 armor : wearer.method_5661()) {
                        if (armor.method_7986()) {
                            armor.method_7974(armor.method_7919() - 1);
                        }
                    }
                    wearer.method_37908().method_8396(null, wearer.method_24515(),
                            class_3417.field_26980,
                            class_3419.field_15248, 0.6f, 1.8f);
                }
                break;

            case OBSIDIAN:
                // 黑曜石盔甲专属效果：黑曜石碎片反射
                float reflectChance = 0.15f;
                if (RANDOM.nextFloat() < reflectChance) {
                    // 造成3点伤害
                    attacker.method_5643(attacker.method_48923().method_48818(wearer), 3.0f);

                    // 击退效果
                    attacker.method_6005(0.5f,
                            wearer.method_23317() - attacker.method_23317(),
                            wearer.method_23321() - attacker.method_23321());

                    // 粒子效果和音效
                    if (wearer.method_37908() instanceof class_3218 serverWorld) {
                        serverWorld.method_14199(class_2398.field_11205,
                                attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(),
                                10, 0.3, 0.3, 0.3, 0.1);
                        serverWorld.method_8396(null, attacker.method_24515(),
                                class_3417.field_15081,
                                class_3419.field_15248, 0.8f, 1.2f);
                    }
                }
                break;
        }
    }

    // 辅助方法：从盔甲获取材料
    private static ModArmorMaterials getArmorMaterial(class_1799 stack) {
        if (stack.method_7909() instanceof class_1738 armorItem &&
                armorItem.method_7686() instanceof ModArmorMaterials mat) {
            return mat;
        }
        return null;
    }

    // 检查是否穿戴任意黑曜石盔甲
    private static boolean hasAnyObsidianArmor(class_1309 entity) {
        for (class_1799 armor : entity.method_5661()) {
            if (isObsidianArmor(armor)) {
                return true;
            }
        }
        return false;
    }

    // 检查单件盔甲是否为黑曜石材质
    private static boolean isObsidianArmor(class_1799 stack) {
        return stack.method_7909() instanceof class_1738 armorItem &&
                armorItem.method_7686() == ModArmorMaterials.OBSIDIAN;
    }

    private static void applyContinuousEffects(class_1657 player) {
        for (Map.Entry<ModArmorMaterials, List<class_1293>> entry : ARMOR_EFFECTS_MAP.entrySet()) {
            ModArmorMaterials material = entry.getKey();
            List<class_1293> effects = entry.getValue();

            if (hasFullSet(player, material)) {
                for (class_1293 effect : effects) {
                    applyEffectWithRefresh(player, effect);
                }
            }
        }
    }

    // 应用黑曜石全套特殊效果
    private static void applyObsidianFullSetEffects(class_1657 player) {
        if (hasFullSet(player, ModArmorMaterials.OBSIDIAN)) {
            // 这里可以添加黑曜石全套的特殊效果
            // 例如每5秒回复1点耐久
            if (player.method_37908().method_8510() % 100 == 0) { // 每5秒
                for (class_1799 armor : player.method_5661()) {
                    if (armor.method_7986() && isObsidianArmor(armor)) {
                        armor.method_7974(armor.method_7919() - 1);
                    }
                }
            }
        }
    }

    private static void applyEffectWithRefresh(class_1657 player, class_1293 effect) {
        class_1293 current = player.method_6112(effect.method_5579());

        if (current == null || current.method_5584() <= 10) {
            player.method_6092(new class_1293(
                    effect.method_5579(),
                    20,
                    effect.method_5578(),
                    false, false, true
            ));
        }
    }

    private static boolean hasFullSet(class_1657 player, ModArmorMaterials material) {
        return isArmorOfMaterial(player.method_6118(class_1304.field_6169), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6174), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6172), material) &&
                isArmorOfMaterial(player.method_6118(class_1304.field_6166), material);
    }

    private static boolean isArmorOfMaterial(class_1799 stack, ModArmorMaterials material) {
        return stack.method_7909() instanceof class_1738 armorItem &&
                armorItem.method_7686() == material;
    }
}