package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class BlueIceToolUseEvent {

    private static final int DURABILITY_COST = 30;
    private static final int SHIELD_DURATION = 8 * 20; // 8秒

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.BLUE_ICE) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        // 消耗耐久
                        stack.method_7956(DURABILITY_COST, player, p -> p.method_20236(hand));
                        
                        // 给予抗性提升
                        player.method_6092(new class_1293(
                            class_1294.field_5907, 
                            SHIELD_DURATION, 
                            0 // 等级I（20%减伤）
                        ));

                        
                        // 粒子效果
                        if (world instanceof class_3218 serverWorld) {
                            serverWorld.method_14199(class_2398.field_28013,
                                player.method_23317(), player.method_23318() + 1, player.method_23321(),
                                50, 1, 1, 1, 0.2);
                        }
                        
                        // 音效
                        world.method_8396(null, player.method_24515(),
                            class_3417.field_15081,
                            class_3419.field_15248, 1.0f, 0.8f);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }
}