package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.entity.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BoneToolUseEvent {

    private static final int DURABILITY_COST = 250/5;
    private static final int SHIELD_DURATION = 100; // 10秒
    private static final Map<UUID, Long> activeShields = new HashMap<>(); // 玩家UUID到结束时间的映射
    private static final Map<UUID, List<class_1297>> playerBones = new HashMap<>(); // 玩家UUID到骨头实体的映射

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.BONE) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));
                        activateBoneShield(player, (class_3218) world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void activateBoneShield(class_1657 player, class_3218 world) {
        // 清除之前的骨头
        clearActiveBonesForPlayer(player);

        // 添加伤害吸收效果
        player.method_6092(new class_1293(
                class_1294.field_5898,
                SHIELD_DURATION,
                2, // 吸收4颗心
                false,
                true
        ));

        // 记录护盾结束时间（当前世界时间 + 持续时间）
        activeShields.put(player.method_5667(), world.method_8510() + SHIELD_DURATION);

        // 创建新的骨头实体列表
        List<class_1297> bones = new ArrayList<>();
        playerBones.put(player.method_5667(), bones);

        // 生成3个盔甲架作为旋转的骨头
        for (int i = 0; i < 3; i++) {
            class_1297 armorStand = class_1299.field_6131.method_5883(world);
            if (armorStand != null) {
                armorStand.method_33574(player.method_19538());
                armorStand.method_5875(true);
                armorStand.method_5684(true);
                armorStand.method_5648(true); // 不可见
                armorStand.method_5803(true);
                armorStand.method_5780("bone_shield");
                world.method_8649(armorStand);
                bones.add(armorStand);
            }
        }

        // 播放音效
        world.method_8396(null, player.method_24515(),
                class_3417.field_14588,
                class_3419.field_15248, 1.0f, 0.8f);
    }

    private static void clearActiveBonesForPlayer(class_1657 player) {
        List<class_1297> bones = playerBones.get(player.method_5667());
        if (bones != null) {
            for (class_1297 bone : bones) {
                if (bone.method_5805()) {
                    bone.method_31472();
                }
            }
            playerBones.remove(player.method_5667());
        }
        activeShields.remove(player.method_5667());
    }

    // 这个方法需要在每个tick调用
    public static void updateBoneShields(class_3218 world) {
        long currentTime = world.method_8510();

        // 检查所有活动的护盾
        for (Map.Entry<UUID, Long> entry : new ArrayList<>(activeShields.entrySet())) {
            UUID playerId = entry.getKey();
            long endTime = entry.getValue();

            // 如果护盾过期，清除骨头
            if (currentTime >= endTime) {
                class_1657 player = world.method_18470(playerId);
                if (player != null) {
                    clearActiveBonesForPlayer(player);
                } else {
                    activeShields.remove(playerId);
                    playerBones.remove(playerId);
                }
                continue;
            }

            // 更新骨头位置
            class_1657 player = world.method_18470(playerId);
            if (player == null) continue;

            List<class_1297> bones = playerBones.get(playerId);
            if (bones == null || bones.isEmpty()) continue;

            // 更新每个骨头的位置
            for (int i = 0; i < bones.size(); i++) {
                class_1297 bone = bones.get(i);
                if (!bone.method_5805()) continue;

                // 计算旋转角度：每个骨头间隔120度
                double angle = (currentTime % 360) * Math.PI / 180.0 + (i * 120 * Math.PI / 180.0);
                double radius = 1.5;
                double x = player.method_23317() + radius * Math.cos(angle);
                double y = player.method_23318() + 1.0;
                double z = player.method_23321() + radius * Math.sin(angle);

                bone.method_5814(x, y, z);

                // 粒子效果
                world.method_14199(class_2398.field_22247,
                        bone.method_23317(), bone.method_23318(), bone.method_23321(),
                        2, 0.1, 0.1, 0.1, 0.01);

                // 伤害附近的敌人
                class_238 area = bone.method_5829().method_1014(0.5);
                for (class_1297 entity : world.method_8335(player, area)) {
                    if (entity instanceof class_1309 && !entity.method_5752().contains("bone_shield")) {
                        // 使用正确的伤害来源
                        entity.method_5643(world.method_48963().method_48831(), 2.0f);
                    }
                }

                // 反弹投射物
                for (class_1297 projectile : world.method_8335(bone, bone.method_5829())) {
                    if (projectile instanceof class_1676) {
                        class_243 velocity = projectile.method_18798();
                        projectile.method_18800(-velocity.field_1352, -velocity.field_1351, -velocity.field_1350);
                    }
                }
            }
        }
    }
}